/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ConstructionCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -5857500094506755337L;
    private static final double OLD_CONSTRUCTION_DAYS_DEFAULT = 730.0;
    private static final double OLD_CHECK_DATE_MONTHS_DEFAULT = 6.0;
    private static final String CONSTRUCTION_PASSED_DATE = "The {0} tag has been exceeded. If the construction is still ongoing please update the date with a new completion date from an official source. Otherwise please modify this to be a completed feature";
    private static final String CONSTRUCTION_CHECK_DATE_OLD = "It has been more than {0} months since this construction was last checked. If this is still under construction please update the check_date tag. Otherwise please modify this to be a completed feature.";
    private static final String CONSTRUCTION_LAST_EDITED_OLD = "This feature has had a construction tag, with no updates, for more than {0} days. If this is still under construction please update the check_date tag. Otherwise please modify this to be a completed feature.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The {0} tag has been exceeded. If the construction is still ongoing please update the date with a new completion date from an official source. Otherwise please modify this to be a completed feature", "It has been more than {0} months since this construction was last checked. If this is still under construction please update the check_date tag. Otherwise please modify this to be a completed feature.", "This feature has had a construction tag, with no updates, for more than {0} days. If this is still under construction please update the check_date tag. Otherwise please modify this to be a completed feature.");
    private static final List<DateTimeFormatter> YEAR_FORMATTERS = Collections.singletonList(DateTimeFormatter.ofPattern("yyyy"));
    private static final List<DateTimeFormatter> YEAR_MONTH_FORMATTERS = Arrays.asList(DateTimeFormatter.ofPattern("yyyy-M"), DateTimeFormatter.ofPattern("M-yyyy"), DateTimeFormatter.ofPattern("MMM-yyyy"), DateTimeFormatter.ofPattern("MMMM yyyy"));
    private static final List<DateTimeFormatter> FULL_DATE_FORMATTERS = Arrays.asList(DateTimeFormatter.ofPattern("yyyy-M-d"), DateTimeFormatter.ofPattern("d-M-yyyy"), DateTimeFormatter.ofPattern("d-MMM-yyyy"), DateTimeFormatter.ofPattern("d MMMM yyyy"));
    private static final DateTimeFormatter ATLAS_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final LocalDate TODAYS_DATE = LocalDate.now();
    private static final List<String> DATE_TAGS = Arrays.asList("opening_date", "open_date", "construction:date", "temporary:date_on", "date_on");
    private static final List<String> CONSTRUCTION_TAGS = List.of("highway", "landuse", "building");
    private final int oldConstructionDays;
    private final int oldCheckDateMonths;

    public ConstructionCheck(Configuration configuration) {
        super(configuration);
        this.oldConstructionDays = this.configurationValue(configuration, "oldConstructionDays", 730.0, Double::intValue);
        this.oldCheckDateMonths = this.configurationValue(configuration, "oldCheckDateMonth", 6.0, Double::intValue);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        Map keySet = object.getOsmTags();
        return !this.isFlagged(object.getOsmIdentifier()) && this.isConstruction(keySet);
    }

    @Override
    protected CheckFlag createFlag(AtlasObject object, String instruction) {
        if (object instanceof Edge) {
            return super.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction);
        }
        return super.createFlag(object, instruction);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        long timestamp;
        LocalDate lastEditDate;
        long numberOfDays;
        long monthsBetween;
        Optional<LocalDate> parseDateChecked;
        String tagDate;
        Optional<LocalDate> parsedDate;
        Optional atlasDateString = object.getAtlas().metaData().getDataVersion();
        LocalDate comparisonDate = atlasDateString.isPresent() && !((String)atlasDateString.get()).equals("unknown") ? LocalDate.parse(((String)atlasDateString.get()).split("-")[0], ATLAS_DATE_FORMATTER) : TODAYS_DATE;
        this.markAsFlagged(object.getOsmIdentifier());
        Map tags = object.getTags();
        Optional<String> dateTag = this.getDateTag(tags);
        if (dateTag.isPresent() && (parsedDate = this.parseDate(tagDate = (String)tags.get(dateTag.get()))).isPresent() && parsedDate.get().isBefore(comparisonDate)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, dateTag.get())));
        }
        if (tags.containsKey("check_date") && (parseDateChecked = this.parseDate((String)tags.get("check_date"))).isPresent() && (monthsBetween = ChronoUnit.MONTHS.between(parseDateChecked.get(), comparisonDate)) > (long)this.oldCheckDateMonths) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(1, this.oldCheckDateMonths)));
        }
        if (tags.containsKey("last_edit_time") && (numberOfDays = ChronoUnit.DAYS.between(lastEditDate = Instant.ofEpochMilli(timestamp = Long.parseLong((String)tags.get("last_edit_time"))).atZone(ZoneId.systemDefault()).toLocalDate(), comparisonDate)) > (long)this.oldConstructionDays) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(2, this.oldConstructionDays)));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<String> getDateTag(Map<String, String> keySet) {
        return DATE_TAGS.stream().filter(keySet::containsKey).findFirst();
    }

    private boolean isConstruction(Map<String, String> tags) {
        return tags.keySet().stream().anyMatch(tag -> tag.equals("construction") || tag.startsWith("construction:") && !tag.equals("construction:date")) || CONSTRUCTION_TAGS.stream().anyMatch(tag -> "construction".equals(tags.get(tag)));
    }

    private Optional<LocalDate> parseDate(String tagDate) {
        return Stream.of(YEAR_FORMATTERS.stream().map(format -> {
            try {
                return Year.parse(tagDate, format).atMonth(Month.DECEMBER).atEndOfMonth();
            }
            catch (DateTimeParseException ignored) {
                return null;
            }
        }), YEAR_MONTH_FORMATTERS.stream().map(format -> {
            try {
                return YearMonth.parse(tagDate, format).atEndOfMonth();
            }
            catch (Exception ignored) {
                return null;
            }
        }), FULL_DATE_FORMATTERS.stream().map(format -> {
            try {
                return LocalDate.parse(tagDate, format);
            }
            catch (Exception ignored) {
                return null;
            }
        })).flatMap(s -> s).filter(Objects::nonNull).findAny();
    }
}

