/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class NodeValenceCheck
extends BaseCheck<Long> {
    public static final long MAXIMUM_CONNECTIONS_DEFAULT = 10L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Node {0,number,#} has too many connections ({1} connected edges). Ideally a node shouldn't be connected to more than {2} edges.");
    private static final long serialVersionUID = -6518944438651833609L;
    private final long maximumConnections;

    public NodeValenceCheck(Configuration configuration) {
        super(configuration);
        this.maximumConnections = this.configurationValue(configuration, "connections.maximum", 10L);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Node;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Node node = (Node)object;
        List<Edge> connectedCarNavigableEdges = node.connectedEdges().stream().filter(edge -> edge.isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)edge)).collect(Collectors.toList());
        int valence = connectedCarNavigableEdges.size();
        if ((long)valence > this.maximumConnections) {
            CheckFlag flag = new CheckFlag(String.valueOf(object.getIdentifier()));
            connectedCarNavigableEdges.forEach(flag::addObject);
            flag.addObject(object, this.getLocalizedInstruction(0, node.getOsmIdentifier(), valence, this.maximumConnections));
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

