/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class DuplicatePointCheck
extends BaseCheck<Location> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Nodes {0} are duplicates at {1}");
    private static final long serialVersionUID = 8624313405718452123L;

    public DuplicatePointCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Point && !this.isFlagged(((Point)object).getLocation());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Point point = (Point)object;
        List duplicates = Iterables.asList((Iterable)object.getAtlas().pointsAt(point.getLocation()));
        if (duplicates.size() > 1) {
            this.markAsFlagged(point.getLocation());
            List duplicateIdentifiers = duplicates.stream().map(AtlasEntity::getOsmIdentifier).collect(Collectors.toList());
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, duplicateIdentifiers, point.getLocation())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

