/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class SharpAngleCheck
extends BaseCheck<Long> {
    private static final double THRESHOLD_DEGREES_DEFAULT = 97.0;
    private static final String TOO_SHARP_INSTRUCTION_1 = "Way {0,number,#} has {1} node(s) with angle(s) that are too sharp.";
    private static final String TOO_SHARP_INSTRUCTION_2 = "The node at {0} is too sharp.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Way {0,number,#} has {1} node(s) with angle(s) that are too sharp.", "The node at {0} is too sharp.");
    private static final long serialVersionUID = 285618700794811828L;
    private final Angle threshold;

    public SharpAngleCheck(Configuration configuration) {
        super(configuration);
        this.threshold = this.configurationValue(configuration, "threshold.degrees", 97.0, Angle::degrees);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        if (edge.highwayTag().isLessImportantThan(HighwayTag.TERTIARY)) {
            return Optional.empty();
        }
        List offendingAngles = edge.asPolyLine().anglesGreaterThanOrEqualTo(this.threshold);
        if (!offendingAngles.isEmpty() && !this.hasBeenFlagged(edge)) {
            this.flagEdge(edge);
            List<Location> offendingLocations = this.buildLocationList(offendingAngles);
            CheckFlag newFlag = this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), offendingAngles.size()), offendingLocations);
            for (Location sharpAngle : offendingLocations) {
                newFlag.addInstruction(this.getLocalizedInstruction(1, sharpAngle.toString()));
            }
            return Optional.of(newFlag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private List<Location> buildLocationList(List<Tuple<Angle, Location>> angleTuples) {
        ArrayList<Location> resultList = new ArrayList<Location>();
        angleTuples.forEach(tuple -> resultList.add((Location)tuple.getSecond()));
        return resultList;
    }

    private void flagEdge(Edge edge) {
        this.markAsFlagged(edge.getIdentifier());
        if (edge.hasReverseEdge()) {
            this.markAsFlagged(((Edge)edge.reversed().get()).getIdentifier());
        }
    }

    private boolean hasBeenFlagged(Edge edge) {
        if (edge.hasReverseEdge()) {
            return this.isFlagged(edge.getIdentifier()) || this.isFlagged(((Edge)edge.reversed().get()).getIdentifier());
        }
        return this.isFlagged(edge.getIdentifier());
    }
}

