/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import groovy.lang.Tuple4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.BuildingPartTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class TallBuildingCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -6979838256518757743L;
    private static final String LEVEL_OVER_HUNDRED_INSTRUCTIONS = "Building {0, number, #} has a 'levels' tag over 100 please investigate.";
    private static final String NON_PARSABLE_LEVELS_TAG_INSTRUCTIONS = "Building {0, number, #} has improper building:levels syntax, should be a number. Please refer to https://wiki.openstreetmap.org/wiki/Key:building:levels for proper modeling.";
    private static final String BUILDING_IS_LEVELS_OUTLIER_INSTRUCTIONS = "Building {0, number, #} has an outlying levels tag compared to buildings nearby. Please investigate concerning outlier.";
    private static final String BUILDING_IS_HEIGHT_OUTLIER_INSTRUCTIONS = "Building {0, number, #} has an outlying height tag compared to buildings nearby. Please investigate concerning outlier.";
    private static final String INVALID_HEIGHT_TAG_INSTRUCTIONS = "Building {0, number, #} invalid height tag syntax. Please refer to https://wiki.openstreetmap.org/wiki/Key:height for modeling/syntax details.";
    private static final List<String> FALLBACK_INSTRUCTIONS = List.of("Building {0, number, #} has a 'levels' tag over 100 please investigate.", "Building {0, number, #} has improper building:levels syntax, should be a number. Please refer to https://wiki.openstreetmap.org/wiki/Key:building:levels for proper modeling.", "Building {0, number, #} has an outlying levels tag compared to buildings nearby. Please investigate concerning outlier.", "Building {0, number, #} has an outlying height tag compared to buildings nearby. Please investigate concerning outlier.", "Building {0, number, #} invalid height tag syntax. Please refer to https://wiki.openstreetmap.org/wiki/Key:height for modeling/syntax details.");
    private static final double BUFFER_DISTANCE_DEFAULT = 1600.0;
    private final double bufferDistanceMeters;
    private static final double MIN_DATASET_SIZE_DEFAULT = 50.0;
    private final double minDatasetSizeForStatsComputation;
    private final double maxLevelTagValue;
    private static final double MAX_LEVEL_TAG_VALUE_DEFAULT = 100.0;
    private static final double OUTLIER_MULTIPLIER_DEFAULT = 3.0;
    private final double outlierMultiplier;
    private final Map<Rectangle, Tuple4<String, Double, Double, Double>> storedAreasWithStatistics = new HashMap<Rectangle, Tuple4<String, Double, Double, Double>>();
    private final Set<String> invalidHeightCharacters;
    private static final Set<String> INVALID_CHARACTER_DEFAULT = Set.of("~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "-", "_", "+", "=", "{", "[", "}", "]", "|", "\\", ":", ";", "<", ",", ">", "?", "/");
    private static final int INSTRUCTION_THREE = 3;
    private static final int INSTRUCTION_FOUR = 4;
    private static final double ONE_QUARTER = 0.25;
    private static final double THREE_QUARTERS = 0.75;

    public TallBuildingCheck(Configuration configuration) {
        super(configuration);
        this.bufferDistanceMeters = this.configurationValue(configuration, "buffer.distance.meters", 1600.0);
        this.minDatasetSizeForStatsComputation = this.configurationValue(configuration, "min.dataset.size.for.stats.computation", 50.0);
        this.maxLevelTagValue = this.configurationValue(configuration, "max.level.tag.value", 100.0);
        this.outlierMultiplier = this.configurationValue(configuration, "outlier.multiplier", 3.0);
        this.invalidHeightCharacters = new HashSet<String>((Collection)this.configurationValue(configuration, "invalid.height.characters", INVALID_CHARACTER_DEFAULT));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        Map tags = object.getTags();
        return !(this.isFlagged(object.getOsmIdentifier()) || !(object instanceof Area) && (!(object instanceof Relation) || !((Relation)object).isMultiPolygon()) || !this.isBuildingOrPart(object) && !this.isBuildingRelationMember(object) || !this.hasHeightTag(tags) && !this.hasBuildingLevelTag(tags));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Optional<CheckFlag> flag;
        this.markAsFlagged(object.getOsmIdentifier());
        Map tags = object.getOsmTags();
        if (this.hasBuildingLevelTag(tags) && (flag = this.buildingLevelsTagFlagLogic(object, tags)).isPresent()) {
            return flag;
        }
        if (this.hasHeightTag(tags) && (flag = this.heightTagFlagLogic(object, tags)).isPresent()) {
            return flag;
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<CheckFlag> buildingLevelsTagFlagLogic(AtlasObject object, Map<String, String> tags) {
        double buildingLevelsTagValue;
        try {
            buildingLevelsTagValue = Double.parseDouble(tags.get("building:levels"));
        }
        catch (NumberFormatException e) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(1, object.getOsmIdentifier())));
        }
        if (buildingLevelsTagValue > this.maxLevelTagValue) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        if (!tags.containsKey("building") || !tags.get("building").equalsIgnoreCase(BuildingTag.APARTMENTS.toString())) {
            Optional<Tuple4<String, Double, Double, Double>> rectangleStatsWhichIntersectObjectOptional = this.getRectangleStatsWhichIntersectObject(object, "building:levels");
            if (rectangleStatsWhichIntersectObjectOptional.isPresent() && this.isOutlier(buildingLevelsTagValue, (Double)rectangleStatsWhichIntersectObjectOptional.get().getSecond(), (Double)rectangleStatsWhichIntersectObjectOptional.get().getThird(), (Double)rectangleStatsWhichIntersectObjectOptional.get().getFourth())) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(2, object.getOsmIdentifier())));
            }
            if (rectangleStatsWhichIntersectObjectOptional.isEmpty()) {
                return this.getStatisticsWithNewStoreEntry(object, buildingLevelsTagValue, "building:levels");
            }
        }
        return Optional.empty();
    }

    private Rectangle getBufferArea(Rectangle bounds) {
        return bounds.expand(Distance.meters((double)this.bufferDistanceMeters));
    }

    private Rectangle getBuildingBounds(AtlasObject object) {
        return object.bounds();
    }

    private Optional<Double> getInnerQuartileRange(List<Double> listOfSortedHeights) {
        Optional<Double> lowerQuartile = this.getLowerQuartile(listOfSortedHeights);
        Optional<Double> upperQuartile = this.getUpperQuartile(listOfSortedHeights);
        if (lowerQuartile.isPresent() && upperQuartile.isPresent()) {
            return Optional.of(upperQuartile.get() - lowerQuartile.get());
        }
        return Optional.empty();
    }

    private Set<Map<Long, String>> getIntersectingBuildingsIdAndRelevantTag(AtlasObject object, Iterable<AtlasItem> intersectingItems, String tagIdentifier) {
        HashSet<Map<Long, String>> buildingsWithRelevantTagWithinBuffer = new HashSet<Map<Long, String>>();
        for (AtlasItem atlasItem : intersectingItems) {
            Map tags = atlasItem.getTags();
            if (!this.isBuildingRelationMember(object) && !this.isBuildingOrPart(object) || !tags.containsKey(tagIdentifier)) continue;
            HashMap<Long, String> atlasItemProperties = new HashMap<Long, String>();
            atlasItemProperties.put(atlasItem.getOsmIdentifier(), (String)tags.get(tagIdentifier));
            buildingsWithRelevantTagWithinBuffer.add(atlasItemProperties);
        }
        return buildingsWithRelevantTagWithinBuffer;
    }

    private Optional<Double> getLowerQuartile(List<Double> listOfRelevantTags) {
        int lengthOfList = listOfRelevantTags.size() - 1;
        if (lengthOfList == 0) {
            return Optional.empty();
        }
        return Optional.of(listOfRelevantTags.get((int)Math.round((double)lengthOfList * 0.25)));
    }

    private Optional<Tuple4<String, Double, Double, Double>> getRectangleStatsWhichIntersectObject(AtlasObject object, String tagIdentifier) {
        if (this.storedAreasWithStatistics.size() == 0) {
            return Optional.empty();
        }
        for (Map.Entry<Rectangle, Tuple4<String, Double, Double, Double>> mapEntry : this.storedAreasWithStatistics.entrySet()) {
            Rectangle rectangleKey;
            Rectangle intersection;
            if (!((String)mapEntry.getValue().getFirst()).equals(tagIdentifier) || (intersection = (rectangleKey = mapEntry.getKey()).intersection(object.bounds())) == null) continue;
            return Optional.of(mapEntry.getValue());
        }
        return Optional.empty();
    }

    private List<Double> getSortedTagValuesWithinBufferRadius(Set<Map<Long, String>> buildingsWithRelevantTagWithinBuffer, String tagIdentifier) {
        ArrayList<Double> tagsWithinBuffer = new ArrayList<Double>();
        for (Map<Long, String> buildingWithinBuffer : buildingsWithRelevantTagWithinBuffer) {
            for (Map.Entry<Long, String> entry : buildingWithinBuffer.entrySet()) {
                this.parseAndAddRelativeTagsToTagsWithinBuffer(tagIdentifier, entry, tagsWithinBuffer);
            }
        }
        Collections.sort(tagsWithinBuffer);
        return tagsWithinBuffer;
    }

    private Optional<CheckFlag> getStatisticsWithNewStoreEntry(AtlasObject object, double tagValue, String tagIdentifier) {
        Rectangle bufferArea = this.getBufferArea(this.getBuildingBounds(object));
        Iterable intersectingItems = object.getAtlas().itemsIntersecting((GeometricSurface)bufferArea);
        Set<Map<Long, String>> intersectingBuildingsWithRelevantTags = this.getIntersectingBuildingsIdAndRelevantTag(object, intersectingItems, tagIdentifier);
        List<Double> sortedTagValueList = this.getSortedTagValuesWithinBufferRadius(intersectingBuildingsWithRelevantTags, tagIdentifier);
        if ((double)sortedTagValueList.size() >= this.minDatasetSizeForStatsComputation) {
            Optional<Double> lowerQuartile = this.getLowerQuartile(sortedTagValueList);
            Optional<Double> upperQuartile = this.getUpperQuartile(sortedTagValueList);
            Optional<Double> innerQuartileRange = this.getInnerQuartileRange(sortedTagValueList);
            if (lowerQuartile.isPresent() && upperQuartile.isPresent() && innerQuartileRange.isPresent()) {
                this.storedAreasWithStatistics.put(bufferArea, (Tuple4<String, Double, Double, Double>)new Tuple4((Object)tagIdentifier, (Object)lowerQuartile.get(), (Object)upperQuartile.get(), (Object)innerQuartileRange.get()));
                if (this.isOutlier(tagValue, lowerQuartile.get(), upperQuartile.get(), innerQuartileRange.get()) && tagIdentifier.equals("building:levels")) {
                    return Optional.of(this.createFlag(object, this.getLocalizedInstruction(2, object.getOsmIdentifier())));
                }
                if (this.isOutlier(tagValue, lowerQuartile.get(), upperQuartile.get(), innerQuartileRange.get()) && tagIdentifier.equals("height")) {
                    return Optional.of(this.createFlag(object, this.getLocalizedInstruction(4, object.getOsmIdentifier())));
                }
            }
        }
        return Optional.empty();
    }

    private Optional<Double> getUpperQuartile(List<Double> listOfRelevantTags) {
        int lengthOfList = listOfRelevantTags.size() - 1;
        if (lengthOfList == 0) {
            return Optional.empty();
        }
        return Optional.of(listOfRelevantTags.get((int)Math.round((double)lengthOfList * 0.75)));
    }

    private boolean hasBuildingLevelTag(Map<String, String> tags) {
        return tags.containsKey("building:levels");
    }

    private boolean hasHeightTag(Map<String, String> tags) {
        return tags.containsKey("height");
    }

    private boolean hasInvalidHeightTag(String heightTag) {
        return !heightTag.contains(" ") && heightTag.contains("m") || this.heightTagContainsInvalidCharacter(heightTag).isPresent() || !this.stringContainsNumber(heightTag) || this.parseHeightTag(heightTag).isEmpty();
    }

    private Optional<String> heightTagContainsInvalidCharacter(String heightTag) {
        for (String invalidHeightTagCharacter : this.invalidHeightCharacters) {
            if (!heightTag.contains(invalidHeightTagCharacter)) continue;
            return Optional.of(invalidHeightTagCharacter);
        }
        return Optional.empty();
    }

    private Optional<CheckFlag> heightTagFlagLogic(AtlasObject object, Map<String, String> tags) {
        Optional<Double> buildingHeightTagValue;
        String heightTag = tags.get("height");
        if (this.hasInvalidHeightTag(heightTag)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(4, object.getOsmIdentifier())));
        }
        if (!(tags.containsKey("building") && tags.get("building").equalsIgnoreCase(BuildingTag.APARTMENTS.toString()) || !(buildingHeightTagValue = this.parseHeightTag(heightTag)).isPresent())) {
            Optional<Tuple4<String, Double, Double, Double>> rectangleStatsWhichIntersectObjectOptional = this.getRectangleStatsWhichIntersectObject(object, "height");
            if (rectangleStatsWhichIntersectObjectOptional.isPresent() && this.isOutlier(buildingHeightTagValue.get(), (Double)rectangleStatsWhichIntersectObjectOptional.get().getSecond(), (Double)rectangleStatsWhichIntersectObjectOptional.get().getThird(), (Double)rectangleStatsWhichIntersectObjectOptional.get().getFourth())) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(3, object.getOsmIdentifier())));
            }
            if (rectangleStatsWhichIntersectObjectOptional.isEmpty()) {
                return this.getStatisticsWithNewStoreEntry(object, buildingHeightTagValue.get(), "height");
            }
        }
        return Optional.empty();
    }

    private boolean isBuildingOrPart(AtlasObject object) {
        return BuildingTag.isBuilding((Taggable)object) && (Validators.isNotOfType((Taggable)object, BuildingPartTag.class, (Enum[])new BuildingPartTag[]{BuildingPartTag.NO}) || Validators.isNotOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.ROOF}));
    }

    private boolean isBuildingRelationMember(AtlasObject object) {
        return object instanceof AtlasEntity && ((AtlasEntity)object).relations().stream().anyMatch(relation -> Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.BUILDING}) && relation.members().stream().anyMatch(member -> member.getEntity().equals((Object)object) && member.getRole().equals("outline") || member.getRole().equals("part")));
    }

    private boolean isOutlier(double relevantTag, double lowerQuartile, double upperQuartile, double innerQuartileRange) {
        double innerQuartileRangeAdjusted = innerQuartileRange;
        if (innerQuartileRange < 1.0) {
            innerQuartileRangeAdjusted = innerQuartileRange + 1.0;
        }
        return relevantTag < lowerQuartile - innerQuartileRangeAdjusted * this.outlierMultiplier || relevantTag > upperQuartile + innerQuartileRangeAdjusted * this.outlierMultiplier;
    }

    private void parseAndAddRelativeTagsToTagsWithinBuffer(String tagIdentifier, Map.Entry<Long, String> entry, List<Double> tagsWithinBuffer) {
        if (tagIdentifier.equals("building:levels")) {
            try {
                double levelsTagValue = Double.parseDouble(entry.getValue());
                tagsWithinBuffer.add(levelsTagValue);
            }
            catch (Exception levelsTagValue) {
                // empty catch block
            }
        }
        if (tagIdentifier.equals("height")) {
            try {
                Optional<Double> height = this.parseHeightTag(entry.getValue());
                height.ifPresent(tagsWithinBuffer::add);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Optional<Double> parseHeightTag(String heightTagValue) {
        if (heightTagValue.contains(" ")) {
            try {
                String[] splitString = heightTagValue.split(" ");
                if (splitString.length == 2) {
                    return Optional.of(Double.parseDouble(splitString[0]));
                }
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        try {
            return Optional.of(Double.parseDouble(heightTagValue));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private boolean stringContainsNumber(String heightTag) {
        char[] stringArray;
        for (char stringCharacter : stringArray = heightTag.toCharArray()) {
            if (!Character.isDigit(stringCharacter)) continue;
            return true;
        }
        return false;
    }
}

