/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.tags.BuildingPartTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public class ConcerningAngleBuildingCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 8586559001979110697L;
    private static final String CONCERNING_ANGLE_INSTRUCTIONS = "Area {0, number, #} has concerning angles, please make all angles right angles.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Area {0, number, #} has concerning angles, please make all angles right angles.");
    private static final double ANGLE_DEFAULT = 90.0;
    private static final double MIN_LOW_ANGLE_DIFF_DEFAULT = 80.0;
    private static final double MAX_LOW_ANGLE_DIFF_DEFAULT = 89.9;
    private static final double MIN_HIGH_ANGLE_DIFF_DEFAULT = 90.1;
    private static final double MAX_HIGH_ANGLE_DIFF_DEFAULT = 100.0;
    private static final double MIN_ANGLE_COUNT_DEFAULT = 4.0;
    private static final double MAX_ANGLE_COUNT_DEFAULT = 16.0;
    private final double minLowAngleDiff;
    private final double maxLowAngleDiff;
    private final double minHighAngleDiff;
    private final double maxHighAngleDiff;
    private final double minAngleCount;
    private final double maxAngleCount;

    public ConcerningAngleBuildingCheck(Configuration configuration) {
        super(configuration);
        this.minLowAngleDiff = this.configurationValue(configuration, "angles.minLowAngleDiff", 80.0);
        this.maxLowAngleDiff = this.configurationValue(configuration, "angles.maxLowAngleDiff", 89.9);
        this.minHighAngleDiff = this.configurationValue(configuration, "angles.minHighAngleDiff", 90.1);
        this.maxHighAngleDiff = this.configurationValue(configuration, "angles.maxHighAngleDiff", 100.0);
        this.minAngleCount = this.configurationValue(configuration, "angleCounts.min", 4.0);
        this.maxAngleCount = this.configurationValue(configuration, "angleCounts.max", 16.0);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object.getOsmIdentifier()) && this.isBuildingOrPart(object) && (object instanceof Area || object instanceof Relation && ((Relation)object).isMultiPolygon());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(object.getOsmIdentifier());
        Set buildingPolygons = this.getPolygons(object).collect(Collectors.toSet());
        if (!buildingPolygons.isEmpty()) {
            for (Polygon polygon : buildingPolygons) {
                if (!this.buildingAngleCountWithinValidRange(polygon) || !this.hasConcerningAngles(polygon)) continue;
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean buildingAngleCountWithinValidRange(Polygon polygon) {
        List polygonSegments = polygon.segments();
        return (double)polygonSegments.size() >= this.minAngleCount && (double)polygonSegments.size() <= this.maxAngleCount;
    }

    private double getAngleDiff(Segment segment1, Segment segment2) {
        Optional segmentOneHeading = segment1.heading();
        Optional segmentTwoHeading = segment2.heading();
        if (segmentOneHeading.isPresent() && segmentTwoHeading.isPresent()) {
            return ((Heading)segmentOneHeading.get()).difference((Angle)segmentTwoHeading.get()).asDegrees();
        }
        return 90.0;
    }

    private Stream<Polygon> getPolygons(AtlasObject object) {
        if (object instanceof Area) {
            return Stream.of(((Area)object).asPolygon());
        }
        if (((Relation)object).isMultiPolygon()) {
            return ((Relation)object).members().stream().map(this::toPolygon).flatMap(Optional::stream);
        }
        return Stream.empty();
    }

    private boolean hasConcerningAngles(Polygon polygon) {
        List segments = polygon.segments();
        int segmentSize = segments.size();
        for (Segment segment : segments) {
            if (segments.indexOf(segment) >= segmentSize - 2) continue;
            Segment nextSegment = (Segment)segments.get(segments.indexOf(segment) + 1);
            return this.getAngleDiff(segment, nextSegment) < this.maxLowAngleDiff && this.getAngleDiff(segment, nextSegment) > this.minLowAngleDiff || this.getAngleDiff(segment, nextSegment) < this.maxHighAngleDiff && this.getAngleDiff(segment, nextSegment) > this.minHighAngleDiff;
        }
        return false;
    }

    private boolean isBuildingOrPart(AtlasObject object) {
        return BuildingTag.isBuilding((Taggable)object) || Validators.isNotOfType((Taggable)object, BuildingPartTag.class, (Enum[])new BuildingPartTag[]{BuildingPartTag.NO});
    }

    private Optional<Polygon> toPolygon(RelationMember member) {
        if (member.getEntity().getType().equals((Object)ItemType.AREA)) {
            return Optional.of(((Area)member.getEntity()).asPolygon());
        }
        return Optional.empty();
    }
}

