/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.checks.flag.FlaggedPolyline;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenStreetMapCheckFlagConverter {
    private static final Logger logger = LoggerFactory.getLogger(OpenStreetMapCheckFlagConverter.class);

    public static Optional<CheckFlag> openStreetMapify(CheckFlag flag) {
        CheckFlag newFlag = new CheckFlag(flag.getIdentifier());
        newFlag.addInstructions(flag.getRawInstructions());
        newFlag.setChallengeName(flag.getChallengeName().orElse(null));
        HashMap<String, Set<FlaggedObject>> objectsMap = new HashMap<String, Set<FlaggedObject>>();
        flag.getFlaggedObjects().forEach(object -> {
            String osmIdentifier = object.getUniqueIdentifier().replaceFirst("\\d{6}$", "");
            objectsMap.putIfAbsent(osmIdentifier, new HashSet());
            ((Set)objectsMap.get(osmIdentifier)).add(object);
        });
        HashMap<String, Set<FeatureChange>> suggestionMap = new HashMap<String, Set<FeatureChange>>();
        flag.getFixSuggestions().forEach(suggestion -> {
            String osmIdentifier = String.format("%s%s", StringUtils.capitalize((String)suggestion.getBeforeView().getType().toString()), suggestion.getBeforeView().getOsmIdentifier());
            suggestionMap.putIfAbsent(osmIdentifier, new HashSet());
            ((Set)suggestionMap.get(osmIdentifier)).add(suggestion);
        });
        try {
            objectsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("nullnull")).flatMap(entry -> ((Set)entry.getValue()).stream()).forEach(newFlag::addObject);
            OpenStreetMapCheckFlagConverter.convertFlaggedObjects(objectsMap, newFlag);
            OpenStreetMapCheckFlagConverter.convertFixSuggestions(suggestionMap, newFlag);
        }
        catch (CoreException exception) {
            logger.info("Error converting flag: {}", (Object)exception.getLocalizedMessage());
            return Optional.empty();
        }
        return Optional.of(newFlag);
    }

    private static void convertFixSuggestions(Map<String, Set<FeatureChange>> suggestionMap, CheckFlag newFlag) {
        suggestionMap.entrySet().stream().flatMap(entry -> {
            FeatureChange firstFeatureChange = (FeatureChange)((Set)entry.getValue()).iterator().next();
            switch (((FeatureChange)((Set)entry.getValue()).iterator().next()).getBeforeView().getType()) {
                case EDGE: {
                    Optional<PolyLine> concatenatedBeforePolyline = ((Set)entry.getValue()).stream().map(FeatureChange::getBeforeView).sorted(Comparator.comparing(AtlasObject::getIdentifier)).map(entity -> ((Edge)entity).asPolyLine()).reduce(PolyLine::append);
                    Optional<PolyLine> concatenatedAfterPolyline = ((Set)entry.getValue()).stream().map(FeatureChange::getAfterView).sorted(Comparator.comparing(AtlasObject::getIdentifier)).map(entity -> ((Edge)entity).asPolyLine()).reduce(PolyLine::append);
                    if (concatenatedBeforePolyline.isPresent() && concatenatedAfterPolyline.isPresent()) {
                        return Stream.of(new FeatureChange(firstFeatureChange.getChangeType(), (AtlasEntity)CompleteEdge.from((Edge)((Edge)firstFeatureChange.getAfterView())).withGeometry((Iterable)concatenatedAfterPolyline.get()), (AtlasEntity)CompleteEdge.from((Edge)((Edge)firstFeatureChange.getBeforeView())).withGeometry((Iterable)concatenatedBeforePolyline.get())));
                    }
                    throw new CoreException("Unable to concatenate Edges.");
                }
                case POINT: {
                    return suggestionMap.containsKey(((String)entry.getKey()).replace("POINT", "NODE")) ? Stream.empty() : Stream.of(firstFeatureChange);
                }
            }
            return Stream.of(firstFeatureChange);
        }).forEach(newFlag::addFixSuggestion);
    }

    private static void convertFlaggedObjects(Map<String, Set<FlaggedObject>> objectsMap, CheckFlag newFlag) {
        objectsMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equalsIgnoreCase("nullnull")).flatMap(entry -> {
            switch (ItemType.valueOf((String)((FlaggedObject)((Set)entry.getValue()).iterator().next()).getProperties().get("itemType").toUpperCase())) {
                case EDGE: {
                    Optional<PolyLine> concatenatedPolyline = ((Set)entry.getValue()).stream().sorted(Comparator.comparing(FlaggedObject::getUniqueIdentifier)).map(flaggedObject -> new PolyLine(flaggedObject.getGeometry())).reduce(PolyLine::append);
                    if (concatenatedPolyline.isPresent()) {
                        FlaggedObject object = (FlaggedObject)((Set)entry.getValue()).iterator().next();
                        HashMap<String, String> properties = new HashMap<String, String>(object.getProperties());
                        properties.remove("osmIdentifier");
                        properties.remove("itemType");
                        properties.remove("identifier");
                        return Stream.of(new FlaggedPolyline((AtlasItem)new CompleteEdge(Long.valueOf(object.getProperties().get("osmIdentifier") + "000000"), concatenatedPolyline.get(), properties, null, null, null)));
                    }
                    throw new CoreException("Unable to concatenate Edges.");
                }
                case POINT: {
                    return objectsMap.containsKey(((String)entry.getKey()).replace("Point", "Node")) ? Stream.empty() : ((Set)entry.getValue()).stream();
                }
            }
            return ((Set)entry.getValue()).stream();
        }).forEach(newFlag::addObject);
    }

    private OpenStreetMapCheckFlagConverter() {
    }
}

