/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressionUtilities {
    private static final Logger logger = LoggerFactory.getLogger(CompressionUtilities.class);

    public static InputStream getUncompressedInputStream(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInput = new BufferedInputStream(inputStream);
        try {
            return CompressionUtilities.decompressedInputStream(bufferedInput);
        }
        catch (IOException | CompressorException throwable) {
            try {
                return CompressionUtilities.unarchivedInputStream(bufferedInput);
            }
            catch (IOException | ArchiveException e) {
                return bufferedInput;
            }
        }
    }

    private static InputStream decompressedInputStream(InputStream inputStream) throws IOException, CompressorException {
        CompressorInputStream uncompressed = new CompressorStreamFactory().createCompressorInputStream(inputStream);
        BufferedInputStream buffered = new BufferedInputStream((InputStream)uncompressed);
        try {
            return CompressionUtilities.unarchivedInputStream(buffered);
        }
        catch (IOException | ArchiveException throwable) {
            return buffered;
        }
    }

    private static InputStream unarchivedInputStream(InputStream inputStream) throws IOException, ArchiveException {
        ArchiveInputStream toRead = new ArchiveStreamFactory().createArchiveInputStream(inputStream);
        try {
            toRead.getNextEntry();
        }
        catch (IOException e) {
            logger.trace(e.getLocalizedMessage());
        }
        return toRead;
    }

    private CompressionUtilities() {
    }
}

