/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.oneway.OneWayTag;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonMethods {
    private static final Logger logger = LoggerFactory.getLogger(CommonMethods.class);
    private static final int MODULUS = 1000000;

    public static PolyLine buildOriginalOsmWayGeometry(Edge edge) {
        ArrayList sortedEdges = new ArrayList(new OsmWayWalker(edge).collectEdges());
        PolyLine geometry = null;
        try {
            geometry = OneWayTag.isOneWayReversed((Taggable)edge) ? new PolyLine(((Edge)sortedEdges.get(0)).getRawGeometry()).reversed() : new PolyLine(((Edge)sortedEdges.get(0)).getRawGeometry());
            for (int index = 1; index < sortedEdges.size(); ++index) {
                geometry = OneWayTag.isOneWayReversed((Taggable)edge) ? geometry.append(((Edge)sortedEdges.get(index)).asPolyLine().reversed()) : geometry.append(((Edge)sortedEdges.get(index)).asPolyLine());
            }
        }
        catch (CoreException exception) {
            logger.warn("Unable to build geometry for edge {}({}): {}", new Object[]{edge.getIdentifier(), edge.getOsmIdentifier(), exception.getMessage()});
        }
        return geometry;
    }

    public static long getOSMRelationMemberSize(Relation relation) {
        return relation.members().stream().map(RelationMember::getEntity).map(entity -> {
            if (entity.getType().toString().matches("POINT|NODE")) {
                return "PointNode".concat(String.valueOf(entity.getOsmIdentifier()));
            }
            return entity.getType().toString().concat(String.valueOf(entity.getOsmIdentifier()));
        }).distinct().count();
    }

    public static boolean isClosedWay(Edge edge) {
        HashSet<Long> wayIds = new HashSet<Long>();
        Edge nextEdge = edge;
        while (nextEdge != null) {
            wayIds.add(nextEdge.getIdentifier());
            List nextEdgeList = Iterables.stream((Iterable)nextEdge.outEdges()).filter(Edge::isMainEdge).filter(outEdge -> outEdge.getOsmIdentifier() == edge.getOsmIdentifier()).collectToList();
            if ((nextEdge = nextEdgeList.isEmpty() ? null : (Edge)nextEdgeList.get(0)) == null || !wayIds.contains(nextEdge.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFirstWaySection(Edge edge) {
        return edge.getIdentifier() % 1000000L == 1L;
    }

    private CommonMethods() {
    }
}

