/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.StringUtils;
import org.openstreetmap.atlas.checks.maproulette.data.cooperative_challenge.TagChangeOperation;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescription;

public class Task {
    protected static final String FEATURE = "Feature";
    protected static final String POINT = "Point";
    protected static final String TASK_FEATURES = "features";
    protected static final String TASK_FEATURE_COORDINATES = "coordinates";
    protected static final String TASK_FEATURE_GEOMETRY = "geometry";
    protected static final String TASK_FEATURE_PROPERTIES = "properties";
    protected static final String TASK_GEOMETRIES = "geometries";
    protected static final String TASK_INSTRUCTION = "instruction";
    protected static final String TASK_NAME = "name";
    protected static final String TASK_PARENT_ID = "parent";
    protected static final String TASK_TYPE = "type";
    private static final String KEY_DESCRIPTION = "description";
    private static final String CHECK_GENERATOR = "flag:check";
    private static final String FRAMEWORK_GENERATOR = "flag:generator";
    private static final String FRAMEWORK = "Atlas Checks";
    private static final String COOPERATIVE_WORK = "cooperativeWork";
    private String challengeName;
    private Optional<JsonArray> geoJson = Optional.empty();
    private String instruction;
    private final Set<PointInformation> points = new HashSet<PointInformation>();
    private String projectName = "";
    private String taskIdentifier;
    private List<JsonObject> cooperativeWork;

    public void addPoint(Location point, String description) {
        this.points.add(new PointInformation(point, Optional.ofNullable(description)));
    }

    public boolean equals(Object obj) {
        return obj instanceof Task && StringUtils.equals((CharSequence)this.taskIdentifier, (CharSequence)((Task)obj).getTaskIdentifier()) && StringUtils.equals((CharSequence)this.challengeName, (CharSequence)((Task)obj).getChallengeName());
    }

    public JsonObject generateTask(long parentIdentifier) {
        JsonObject task = new JsonObject();
        JsonObject result = new JsonObject();
        result.addProperty(TASK_TYPE, "FeatureCollection");
        result.add(TASK_FEATURES, (JsonElement)this.generateTaskFeatures(this.points, this.geoJson));
        if (this.cooperativeWork != null && !this.cooperativeWork.isEmpty()) {
            result.add(COOPERATIVE_WORK, (JsonElement)this.generateTaskCooperativeWork(this.cooperativeWork));
        }
        task.add(TASK_INSTRUCTION, (JsonElement)new JsonPrimitive(this.instruction));
        task.add(TASK_NAME, (JsonElement)new JsonPrimitive(this.getTaskIdentifier()));
        task.add(TASK_PARENT_ID, (JsonElement)new JsonPrimitive((Number)parentIdentifier));
        task.add(TASK_GEOMETRIES, (JsonElement)result);
        return task;
    }

    public String getChallengeName() {
        return this.challengeName;
    }

    public Optional<JsonArray> getGeoJson() {
        return this.geoJson;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public Set<Location> getPoints() {
        return this.points.parallelStream().map(PointInformation::getLocation).collect(Collectors.toSet());
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public int hashCode() {
        return this.taskIdentifier.hashCode() + this.challengeName.hashCode();
    }

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    public void setCooperativeWork(Set<FeatureChange> fixSuggestions) {
        this.cooperativeWork = new FixSuggestionToCooperativeWorkConvertor(fixSuggestions).convert();
    }

    public void setGeoJson(Optional<JsonArray> geoJson) {
        this.geoJson = geoJson;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setPoint(Location point) {
        this.points.add(new PointInformation(point, Optional.empty()));
    }

    public void setPoints(Set<Location> points) {
        this.points.addAll(points.parallelStream().map(point -> new PointInformation((Location)point, Optional.empty())).collect(Collectors.toSet()));
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setTaskIdentifier(String taskIdentifier) {
        this.taskIdentifier = taskIdentifier;
    }

    private JsonObject generateTaskCooperativeWork(List<JsonObject> cooperativeWork) {
        JsonObject cooperativeWorkObject = new JsonObject();
        JsonObject meta = new JsonObject();
        meta.add("version", (JsonElement)new JsonPrimitive((Number)2));
        meta.add(TASK_TYPE, (JsonElement)new JsonPrimitive((Number)1));
        cooperativeWorkObject.add("meta", (JsonElement)meta);
        JsonArray cooperativeWorkArray = new JsonArray();
        cooperativeWork.forEach(arg_0 -> ((JsonArray)cooperativeWorkArray).add(arg_0));
        cooperativeWorkObject.add("operations", (JsonElement)cooperativeWorkArray);
        return cooperativeWorkObject;
    }

    private JsonArray generateTaskFeatures(Set<PointInformation> source, Optional<JsonArray> geoJson) {
        JsonArray features = new JsonArray();
        if (source.isEmpty() && !geoJson.isPresent()) {
            throw new CoreException("Could not find any features for the task [{}].", new Object[]{this.toString()});
        }
        source.forEach(point -> {
            JsonObject feature = new JsonObject();
            JsonObject geometry = new JsonObject();
            JsonArray coordinates = new JsonArray();
            coordinates.add((JsonElement)new JsonPrimitive((Number)point.getLocation().getLongitude().asDegrees()));
            coordinates.add((JsonElement)new JsonPrimitive((Number)point.getLocation().getLatitude().asDegrees()));
            geometry.add(TASK_TYPE, (JsonElement)new JsonPrimitive(POINT));
            geometry.add(TASK_FEATURE_COORDINATES, (JsonElement)coordinates);
            feature.add(TASK_FEATURE_GEOMETRY, (JsonElement)geometry);
            feature.add(TASK_TYPE, (JsonElement)new JsonPrimitive(FEATURE));
            JsonObject pointInformation = new JsonObject();
            point.getDescription().ifPresent(description -> pointInformation.add(KEY_DESCRIPTION, (JsonElement)new JsonPrimitive(description)));
            feature.add(TASK_FEATURE_PROPERTIES, (JsonElement)pointInformation);
            features.add((JsonElement)feature);
        });
        geoJson.ifPresent(json -> {
            JsonObject propertiesField = (JsonObject)json.get(0).getAsJsonObject().get(TASK_FEATURE_PROPERTIES);
            propertiesField.add(CHECK_GENERATOR, (JsonElement)new JsonPrimitive(this.challengeName));
            propertiesField.add(FRAMEWORK_GENERATOR, (JsonElement)new JsonPrimitive(FRAMEWORK));
            json.forEach(arg_0 -> ((JsonArray)features).add(arg_0));
        });
        return features;
    }

    private static final class FixSuggestionToCooperativeWorkConvertor {
        private final Set<FeatureChange> featureChanges;

        private FixSuggestionToCooperativeWorkConvertor(Set<FeatureChange> featureChanges) {
            this.featureChanges = featureChanges;
        }

        private List<JsonObject> convert() {
            ArrayList<JsonObject> operationsList = new ArrayList<JsonObject>();
            for (FeatureChange featureChange : this.featureChanges) {
                ChangeDescription whatChanged = featureChange.explain();
                operationsList.add(new TagChangeOperation(whatChanged).create().getJson());
            }
            return operationsList;
        }
    }

    private class PointInformation {
        private final Location location;
        private final Optional<String> description;

        PointInformation(Location location, Optional<String> description) {
            this.location = location;
            this.description = description;
        }

        public Optional<String> getDescription() {
            return this.description;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

