/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag.serializer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.geojson.parser.domain.feature.Feature;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.LineString;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.MultiPolygon;

public final class GeoJsonFeatureToAtlasEntityConverter {
    private static final List<String> metaProperties = Arrays.asList("itemType", "identifier", "osmIdentifier", "relations", "members", "flag:id", "flag:type");
    private static final Long DEFAULT_IDENTIFIER = 0L;

    public static Optional<AtlasEntity> convert(Feature feature) {
        switch (ItemType.valueOf((String)feature.getProperties().asMap().get("itemType").toString().toUpperCase())) {
            case AREA: {
                return Optional.of(GeoJsonFeatureToAtlasEntityConverter.convertArea(feature));
            }
            case EDGE: {
                return Optional.of(GeoJsonFeatureToAtlasEntityConverter.convertEdge(feature));
            }
            case LINE: {
                return Optional.of(GeoJsonFeatureToAtlasEntityConverter.convertLine(feature));
            }
            case NODE: {
                return Optional.of(GeoJsonFeatureToAtlasEntityConverter.convertNode(feature));
            }
            case POINT: {
                return Optional.of(GeoJsonFeatureToAtlasEntityConverter.convertPoint(feature));
            }
            case RELATION: {
                return Optional.of(GeoJsonFeatureToAtlasEntityConverter.convertRelation(feature));
            }
        }
        return Optional.empty();
    }

    private static Area convertArea(Feature feature) {
        return new CompleteArea(Long.valueOf((String)feature.getProperties().asMap().get("identifier")), new Polygon((Iterable)((LineString)feature.getGeometry()).toAtlasGeometry()), GeoJsonFeatureToAtlasEntityConverter.getProperties(feature), Collections.emptySet());
    }

    private static Edge convertEdge(Feature feature) {
        return new CompleteEdge(Long.valueOf((String)feature.getProperties().asMap().get("identifier")), ((LineString)feature.getGeometry()).toAtlasGeometry(), GeoJsonFeatureToAtlasEntityConverter.getProperties(feature), DEFAULT_IDENTIFIER, DEFAULT_IDENTIFIER, Collections.emptySet());
    }

    private static Line convertLine(Feature feature) {
        return new CompleteLine(Long.valueOf((String)feature.getProperties().asMap().get("identifier")), ((LineString)feature.getGeometry()).toAtlasGeometry(), GeoJsonFeatureToAtlasEntityConverter.getProperties(feature), Collections.emptySet());
    }

    private static Node convertNode(Feature feature) {
        return new CompleteNode(Long.valueOf((String)feature.getProperties().asMap().get("identifier")), ((org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.Point)feature.getGeometry()).toAtlasGeometry(), GeoJsonFeatureToAtlasEntityConverter.getProperties(feature), new TreeSet(), new TreeSet(), Collections.emptySet());
    }

    private static Point convertPoint(Feature feature) {
        return new CompletePoint(Long.valueOf((String)feature.getProperties().asMap().get("identifier")), ((org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.Point)feature.getGeometry()).toAtlasGeometry(), GeoJsonFeatureToAtlasEntityConverter.getProperties(feature), Collections.emptySet());
    }

    private static Relation convertRelation(Feature feature) {
        RelationBean members = new RelationBean();
        ((List)feature.getProperties().asMap().get("members")).forEach(member -> {
            Map memberMap = (Map)member;
            members.add(new RelationBean.RelationBeanItem(memberMap.get("identifier") instanceof Integer ? Long.valueOf(((Integer)memberMap.get("identifier")).intValue()) : (Long)memberMap.get("identifier"), (String)memberMap.get("role"), ItemType.valueOf((String)((String)memberMap.get("itemType")))));
        });
        Long identifier = Long.valueOf((String)feature.getProperties().asMap().get("identifier"));
        return new CompleteRelation(identifier, GeoJsonFeatureToAtlasEntityConverter.getProperties(feature), ((MultiPolygon)feature.getGeometry()).toAtlasGeometry().bounds(), members, Collections.singletonList(identifier), members, Long.valueOf((String)feature.getProperties().asMap().get("osmIdentifier")), Collections.emptySet());
    }

    private static Map<String, String> getProperties(Feature feature) {
        return feature.getProperties().asMap().entrySet().stream().filter(entry -> !metaProperties.contains(entry.getKey())).filter(entry -> entry.getValue() instanceof String).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), (String)entry.getValue()), Map::putAll);
    }

    private GeoJsonFeatureToAtlasEntityConverter() {
    }
}

