/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class UnknownHighwayTagCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -7273798399961675550L;
    private static final String NODE_WITH_WAY_TAG_INSTRUCTIONS = "This Node's highway tag only belongs on a Way, please update this Node's tag with only Node related tags. List of tags can be found at https://wiki.openstreetmap.org/wiki/Key:highway";
    private static final String WAY_WITH_NODE_TAG_INSTRUCTIONS = "This Way's highway tag only belongs on a Node, please update this Way's tag with only Way related tags. List of tags can be found at https://wiki.openstreetmap.org/wiki/Key:highway";
    private static final String UNKNOWN_HIGHWAY_TAG_INSTRUCTIONS = "Please update highway tag to a known value.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This Node's highway tag only belongs on a Way, please update this Node's tag with only Node related tags. List of tags can be found at https://wiki.openstreetmap.org/wiki/Key:highway", "This Way's highway tag only belongs on a Node, please update this Way's tag with only Way related tags. List of tags can be found at https://wiki.openstreetmap.org/wiki/Key:highway", "Please update highway tag to a known value.");
    private static final Set<String> allHighwayTags = Arrays.stream(HighwayTag.values()).map(Enum::toString).collect(Collectors.toSet());

    public UnknownHighwayTagCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return (object instanceof Edge && ((Edge)object).isMainEdge() || object instanceof Node) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(object.getOsmIdentifier());
        Optional objectHighwayTag = object.getTag("highway");
        if (object instanceof Node && HighwayTag.isWayOnlyTag((Taggable)object)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        if (object instanceof Edge && HighwayTag.isNodeOnlyTag((Taggable)object)) {
            Edge edgeInQuestion = ((Edge)object).getMainEdge();
            return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker(edgeInQuestion).collectEdges(), this.getLocalizedInstruction(1, object.getOsmIdentifier())));
        }
        if (objectHighwayTag.isPresent() && !this.isKnownHighwayTag(((String)objectHighwayTag.get()).toUpperCase())) {
            if (object instanceof Edge) {
                Edge edgeInQuestion = ((Edge)object).getMainEdge();
                return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker(edgeInQuestion).collectEdges(), this.getLocalizedInstruction(2, object.getOsmIdentifier())));
            }
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(2, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isKnownHighwayTag(String highwayTag) {
        return allHighwayTags.contains(highwayTag);
    }
}

