/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.annotations.validation.ISO2CountryValidator;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class SourceMaxspeedCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -7004341564141771203L;
    private static final String GENERAL_INSTRUCTION = "The element with id {0,number,#} does not follow the source:maxspeed tagging rules";
    private static final String WRONG_VALUE_INSTRUCTION = "The value must be 'sign', 'markings' or follow the country_code:context format.";
    private static final String WRONG_COUNTRY_CODE_INSTRUCTION = "{0} is not a valid country code.";
    private static final String WRONG_CONTEXT_INSTRUCTION = "{0} is not a valid context for the maxspeed source. (valid examples: urban, 30 etc.)";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The element with id {0,number,#} does not follow the source:maxspeed tagging rules", "The value must be 'sign', 'markings' or follow the country_code:context format.", "{0} is not a valid country code.", "{0} is not a valid context for the maxspeed source. (valid examples: urban, 30 etc.)");
    private static final String SOURCE_MAXSPEED = "source:maxspeed";
    private static final List<String> POSSIBLE_VALUES = Arrays.asList("sign", "markings");
    private static final Pattern COUNTRY_CONTEXT_PATTERN = Pattern.compile("[a-zA-Z]{2}:.+");
    private static final Set<String> CONTEXT_VALUES = new HashSet<String>(Arrays.asList("urban", "rural", "bicycle_road", "trunk", "motorway", "living_street", "school", "pedestrian_zone", "urban_motorway", "urban_trunk", "nsl", "express", "nsl_restricted", "nsl_dual", "nsl_single", "zone"));
    private static final List<String> COUNTRY_EXCEPTIONS = Arrays.asList("BE-VLG", "BE-WAL", "BE-BRU");
    private static final String ZONE = "zone";
    private static final int GENERAL_INSTRUCTION_INDEX = 0;
    private static final int VALUE_INSTRUCTION_INDEX = 1;
    private static final int COUNTRY_INSTRUCTION_INDEX = 2;
    private static final int CONTEXT_INSTRUCTION_INDEX = 3;
    private final List<String> exceptedCountries = this.getDenylistCountries();
    private final List<String> possibleValues;
    private final Set<String> contextValues;
    private final List<String> countryExceptions;

    public SourceMaxspeedCheck(Configuration configuration) {
        super(configuration);
        this.possibleValues = this.configurationValue(configuration, "values", POSSIBLE_VALUES);
        this.contextValues = Set.copyOf((Collection)this.configurationValue(configuration, "context.values", CONTEXT_VALUES));
        this.countryExceptions = this.configurationValue(configuration, "country.exceptions", COUNTRY_EXCEPTIONS);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object.getOsmIdentifier()) && (object instanceof Edge || object instanceof Point) && this.hasSourceMaxspeed(object) && object.getTags().containsKey("iso_country_code") && !this.exceptedCountries.contains(object.tag("iso_country_code").toUpperCase());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        String sourceValue;
        Set<String> instructions;
        Optional sourceMaxspeed = object.getTag(SOURCE_MAXSPEED);
        if (sourceMaxspeed.isPresent() && !(instructions = this.testSourceValue(sourceValue = (String)sourceMaxspeed.get())).isEmpty()) {
            this.markAsFlagged(object.getOsmIdentifier());
            String instruction = this.getLocalizedInstruction(0, object.getOsmIdentifier());
            CheckFlag flag = object instanceof Edge ? this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction) : this.createFlag(object, instruction);
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean hasSourceMaxspeed(AtlasObject object) {
        return object.getOsmTags().keySet().stream().anyMatch(key -> key.contains(SOURCE_MAXSPEED));
    }

    private boolean isContextValid(String context) {
        boolean isNumber = context.matches("[0-9].+");
        boolean isZone = context.contains(ZONE);
        boolean isHighwayType = this.contextValues.contains(context);
        return isNumber || isZone || isHighwayType;
    }

    private boolean isCountryValid(String countryCode) {
        ISO2CountryValidator validator = new ISO2CountryValidator();
        return validator.isValid(countryCode) || this.countryExceptions.contains(countryCode);
    }

    private Set<String> testSourceValue(String sourceValue) {
        HashSet<String> instructions = new HashSet<String>();
        Matcher matcher = COUNTRY_CONTEXT_PATTERN.matcher(sourceValue);
        if (matcher.find()) {
            String[] parts = sourceValue.split(":");
            if (!this.isCountryValid(parts[0])) {
                instructions.add(this.getLocalizedInstruction(2, parts[0]));
            }
            if (!this.isContextValid(parts[1])) {
                instructions.add(this.getLocalizedInstruction(3, parts[1]));
            }
        } else if (!this.possibleValues.contains(sourceValue) && !sourceValue.contains(ZONE)) {
            instructions.add(this.getLocalizedInstruction(1, new Object[0]));
        }
        return instructions;
    }
}

