/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class SimilarTagValueCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 6115389966264680867L;
    private static final Predicate<String> HAS_NON_LATIN = Pattern.compile("[^\\d\\s\\p{Punct}\\p{IsLatin}]").asPredicate();
    private static final Predicate<String> HAS_NUMBER = Pattern.compile("\\d").asPredicate();
    private static final String SEMICOLON = ";";
    private static final String DUPLICATE_TAG_VALUE_INSTRUCTION = "The tag \"%s\" contains duplicate values: %s";
    private static final int DUPLICATE_INSTRUCTION_INDEX = 0;
    private static final String SIMILAR_TAG_VALUE_INSTRUCTION = "The tag \"%s\" contains similar values: %s";
    private static final int SIMILAR_INSTRUCTION_INDEX = 1;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The tag \"%s\" contains duplicate values: %s", "The tag \"%s\" contains similar values: %s");
    private static final Double MIN_VALUE_LENGTH = 4.0;
    private static final Double MIN_SIMILARITY_THRESHOLD_DEFAULT = 0.0;
    private static final Double MAX_SIMILARITY_THRESHOLD_DEFAULT = 1.0;
    private static final List<String> TAGS_TO_IGNORE_DEFAULT = List.of("asset_ref", "collection_times", "except", "is_in", "junction:ref", "maxspeed:conditional", "old_name", "old_ref", "opening_hours", "ref", "restriction_hours", "route_ref", "supervised", "source_ref", "target", "telescope");
    private static final List<String> TAGS_WITH_SUB_CATEGORIES_TO_IGNORE_DEFAULT = List.of("addr", "alt_name", "destination", "name", "seamark", "turn");
    private static final List<List<String>> COMMON_SIMILARS_DEFAULT = List.of(List.of("american", "mexican"), List.of("cafe", "cake"), List.of("male", "female"), List.of("woman", "man"), List.of("women", "men"), List.of("male_toilet", "female_toilet"), List.of("radiology", "cardiology"), List.of("baseball", "basketball"), List.of("bowls", "boules"), List.of("padel", "paddel"), List.of("formal", "informal"), List.of("hotel", "hostel"), List.of("hump", "bump"), List.of("seed", "feed"));
    private final List<String> tagsToIgnore;
    private final List<String> tagsWithSubCategoriesToIgnore;
    private final List<List<String>> commonSimilars;
    private final Double minValueLength;
    private final Double minSimilarityThreshold;
    private final Double maxSimilarityThreshold;

    public SimilarTagValueCheck(Configuration configuration) {
        super(configuration);
        this.commonSimilars = this.configurationValue(configuration, "filter.commonSimilars", COMMON_SIMILARS_DEFAULT);
        this.tagsToIgnore = this.configurationValue(configuration, "filter.tags", TAGS_TO_IGNORE_DEFAULT);
        this.tagsWithSubCategoriesToIgnore = this.configurationValue(configuration, "filter.tagsWithSubCategories", TAGS_WITH_SUB_CATEGORIES_TO_IGNORE_DEFAULT);
        this.minValueLength = this.configurationValue(configuration, "value.length.min", MIN_VALUE_LENGTH, Double::doubleValue);
        this.minSimilarityThreshold = this.configurationValue(configuration, "similarity.threshold.min", MIN_SIMILARITY_THRESHOLD_DEFAULT, Double::doubleValue);
        this.maxSimilarityThreshold = this.configurationValue(configuration, "similarity.threshold.max", MAX_SIMILARITY_THRESHOLD_DEFAULT, Double::doubleValue);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object.getOsmTags().values().stream().anyMatch(value -> value.contains(SEMICOLON));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Map<String, String> tagsWithMultipleValues = object.getOsmTags().entrySet().stream().filter(entry -> !this.tagsToIgnore.contains(entry.getKey())).filter(Predicate.not(this::isTagWithSubCategoriesToIgnore)).map(this::removeCommonFalsePositiveValues).filter(entry -> ((String)entry.getValue()).contains(SEMICOLON)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, List<Similar>> tagsWithSimilars = tagsWithMultipleValues.entrySet().stream().map(this::findSimilars).filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, List<Similar>> duplicates = this.filterSimilars(tagsWithSimilars, similar -> similar.getSimilarity() == 0);
        Map<String, List<Similar>> similars = this.filterSimilars(tagsWithSimilars, similar -> similar.getSimilarity() != 0);
        ArrayList instructions = new ArrayList();
        if (!duplicates.isEmpty()) {
            instructions.addAll(duplicates.entrySet().stream().map(entry -> String.format(this.getFallbackInstructions().get(0), entry.getKey(), entry.getValue())).collect(Collectors.toList()));
        }
        if (!similars.isEmpty()) {
            instructions.addAll(similars.entrySet().stream().map(entry -> String.format(this.getFallbackInstructions().get(1), entry.getKey(), entry.getValue())).collect(Collectors.toList()));
        }
        if (!instructions.isEmpty()) {
            Map<String, String> newTags = object.getOsmTags().entrySet().stream().map(entry -> {
                AbstractMap.SimpleEntry newEntry = new AbstractMap.SimpleEntry(entry);
                if (duplicates.containsKey(entry.getKey())) {
                    String valueWithDuplicatesRemoved = Arrays.stream(((String)entry.getValue()).split(SEMICOLON)).distinct().collect(Collectors.joining(SEMICOLON));
                    newEntry.setValue(valueWithDuplicatesRemoved);
                }
                return newEntry;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String instruction = String.join((CharSequence)". ", instructions);
            return Optional.of(this.createFlag(object, instruction).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withTags(newTags)), (Atlas)object.getAtlas())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Map<String, List<Similar>> filterSimilars(Map<String, List<Similar>> tagsWithSimilars, Predicate<Similar> filterBy) {
        return tagsWithSimilars.entrySet().stream().map(entry -> {
            AbstractMap.SimpleEntry newEntry = new AbstractMap.SimpleEntry(entry);
            List newValue = ((List)newEntry.getValue()).stream().filter(filterBy).collect(Collectors.toList());
            newEntry.setValue(newValue);
            return newEntry;
        }).filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private int findEditDistance(String left, String right) {
        try {
            return LevenshteinDistance.getDefaultInstance().apply((CharSequence)left, (CharSequence)right);
        }
        catch (IllegalArgumentException exception) {
            return -1;
        }
    }

    private Map.Entry<String, List<Similar>> findSimilars(Map.Entry<String, String> entry) {
        List<String> values = Arrays.asList(entry.getValue().split(SEMICOLON));
        ArrayList<Similar> similars = new ArrayList<Similar>();
        for (int leftIndex = 0; leftIndex < values.size() - 1; ++leftIndex) {
            for (int rightIndex = leftIndex + 1; rightIndex < values.size(); ++rightIndex) {
                String left = values.get(leftIndex);
                String right = values.get(rightIndex);
                boolean isCommonSimilars = this.isCommonSimilars(left, right);
                boolean duplicates = left.equals(right);
                if (isCommonSimilars && !duplicates) continue;
                int editDistance = this.findEditDistance(left, right);
                if (!(this.minSimilarityThreshold <= (double)editDistance) || !((double)editDistance <= this.maxSimilarityThreshold)) continue;
                similars.add(new Similar(left, right, editDistance));
            }
        }
        return new AbstractMap.SimpleEntry<String, List<Similar>>(entry.getKey(), similars);
    }

    private boolean isCommonSimilars(String left, String right) {
        return this.commonSimilars.stream().anyMatch(setOfSimilars -> setOfSimilars.contains(left) && setOfSimilars.contains(right));
    }

    private boolean isTagWithSubCategoriesToIgnore(Map.Entry<String, String> entry) {
        return this.tagsWithSubCategoriesToIgnore.stream().anyMatch(entry.getKey()::startsWith);
    }

    private Map.Entry<String, String> removeCommonFalsePositiveValues(Map.Entry<String, String> tag) {
        AbstractMap.SimpleEntry<String, String> newTag = new AbstractMap.SimpleEntry<String, String>(tag);
        List splitValues = Arrays.stream(((String)newTag.getValue()).split(SEMICOLON)).filter(value -> (double)value.length() >= this.minValueLength).filter(Predicate.not(HAS_NUMBER)).filter(Predicate.not(HAS_NON_LATIN)).collect(Collectors.toList());
        newTag.setValue(String.join((CharSequence)SEMICOLON, splitValues));
        return newTag;
    }

    private static class Similar {
        private final String similar1;
        private final String similar2;
        private final Integer similarity;

        Similar(String similar1, String similar2, Integer similarity) {
            this.similar1 = similar1;
            this.similar2 = similar2;
            this.similarity = similarity;
        }

        public String getSimilar1() {
            return this.similar1;
        }

        public String getSimilar2() {
            return this.similar2;
        }

        public Integer getSimilarity() {
            return this.similarity;
        }

        public String toString() {
            return String.format("(%s,%s,%d)", this.similar1, this.similar2, this.similarity);
        }
    }
}

