/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.locale.IsoLanguage;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.names.NameTag;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class InvalidCharacterNameTagCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = -1478870354774039269L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("OSM feature with id {0,number,#} has one or more of the following invalid characters in its \"{1}\" tags: numbers, special characters(#$%^&*@~), double quotes or smart quotes(\u201c\u201d).");
    private final Set<String> localizedNameTags = new HashSet<String>();
    private final Pattern invalidCharacterRegexPattern;

    public InvalidCharacterNameTagCheck(Configuration configuration) {
        super(configuration);
        this.invalidCharacterRegexPattern = Pattern.compile(this.configurationValue(configuration, "invalid.char.regex", ""));
        Set languages = IsoLanguage.allLanguageCodes().stream().map(languageCode -> Optional.of((IsoLanguage)IsoLanguage.forLanguageCode((String)languageCode).get())).collect(Collectors.toSet());
        languages.add(Optional.empty());
        for (Optional language : languages) {
            Validators.localizeKeyName(NameTag.class, (Optional)language, (Taggable.TagSearchOption[])new Taggable.TagSearchOption[0]).ifPresent(this.localizedNameTags::add);
        }
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area || object instanceof Line || object instanceof Relation;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        HashSet<String> invalidCharacterNameTags = new HashSet<String>();
        Optional nameTag = NameTag.getNameOf((Taggable)object);
        if (nameTag.isPresent() && this.invalidCharacterRegexPattern.matcher((CharSequence)nameTag.get()).matches()) {
            invalidCharacterNameTags.add("name");
        }
        Iterables.stream(object.getOsmTags().keySet()).filter(this.localizedNameTags::contains).filter(localizedNameTag -> this.invalidCharacterRegexPattern.matcher((CharSequence)object.getTag(localizedNameTag).get()).matches()).forEach(invalidCharacterNameTags::add);
        return invalidCharacterNameTags.isEmpty() ? Optional.empty() : Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), String.join((CharSequence)", ", invalidCharacterNameTags))));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

