/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.relations;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.TurnRestriction;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TurnRestrictionTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class InvalidTurnRestrictionCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Relation ID: {0,number,#} is marked as turn restriction, but it is not well-formed: {1}");
    private static final String MISSING_TO_FROM_INSTRUCTION = "Missing a from and/or to member";
    private static final String UNKNOWN_ISSUE = "Unable to specify issue";
    private static final Map<String, String> INVALID_REASON_INSTRUCTION_MAP = new HashMap<String, String>();
    private static final long serialVersionUID = -983698716949386657L;

    public InvalidTurnRestrictionCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation && TurnRestrictionTag.isRestriction((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Relation relation = (Relation)object;
        Set members = relation.members().stream().map(RelationMember::getEntity).collect(Collectors.toSet());
        if (relation.members().stream().noneMatch(member -> member.getRole().equals("from")) || relation.members().stream().noneMatch(member -> member.getRole().equals("to"))) {
            return Optional.of(this.createFlag(members, this.getLocalizedInstruction(0, relation.getOsmIdentifier(), MISSING_TO_FROM_INSTRUCTION)));
        }
        TurnRestriction turnRestriction = new TurnRestriction(relation);
        if (!turnRestriction.isValid()) {
            return Optional.of(this.createFlag(members, this.getLocalizedInstruction(0, relation.getOsmIdentifier(), this.getInstructionFromInvalidReason(turnRestriction.getInvalidReason()))));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private String getInstructionFromInvalidReason(String invalidReason) {
        String instruction = UNKNOWN_ISSUE;
        for (Map.Entry<String, String> entry : INVALID_REASON_INSTRUCTION_MAP.entrySet()) {
            if (!invalidReason.contains(entry.getKey())) continue;
            instruction = entry.getValue();
            break;
        }
        return instruction;
    }

    static {
        String routeInstruction = "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations";
        INVALID_REASON_INSTRUCTION_MAP.put("Cannot have a route with no members", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
        INVALID_REASON_INSTRUCTION_MAP.put("Restriction relation should not have more than 1 via node.", "A Turn Restriction should only have 1 via Node");
        INVALID_REASON_INSTRUCTION_MAP.put("has same members in from and to, but has no via members to disambiguate.", "Via member is required for restrictions with the same to and from members");
        INVALID_REASON_INSTRUCTION_MAP.put("Can't build route from", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
        INVALID_REASON_INSTRUCTION_MAP.put("Unable to build a route from edges", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
        INVALID_REASON_INSTRUCTION_MAP.put("A route was found from start to end, but not every unique edge was used", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
        INVALID_REASON_INSTRUCTION_MAP.put("No edge that connects to the current route", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
    }
}

