/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.lines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.base.ExternalDataFetcher;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.ElevationUtilities;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class WaterWayCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 2877101774578564205L;
    private static final String WATERWAY_SINK_TAG_FILTER_DEFAULT = "natural->sinkhole|waterway->tidal_channel,drain|manhole->drain";
    private static final String WATERWAY_TAG_FILTER_DEFAULT = "waterway->river,stream,tidal_channel,canal,drain,ditch,pressurised";
    private static final String DOES_NOT_END_IN_SINK = "The waterway {0} does not end in a sink (ocean/sinkhole/waterway/drain).";
    private static final String DOES_NOT_END_IN_SINK_BUT_CROSSING_OCEAN = "The waterway {0} does not end in a sink (ocean/sinkhole/waterway/drain).\nThe waterway crosses a coastline, which means it is possible for the coastline to have an incorrect direction.\nLand should be to the LEFT of the coastline and the ocean should be to the RIGHT of the coastline (for more information, see https://wiki.osm.org/Tag:natural=coastline).";
    private static final String CIRCULAR_WATERWAY = "The waterway {0} loops back on itself. This is typically impossible.";
    private static final String CROSSES_WATERWAY = "The waterway {0} crosses the waterway {1}.";
    private static final String GOES_UPHILL = "The waterway {0} probably does not go up hill.\nPlease check (source elevation data resolution was about {1} meters).";
    private static final Distance MIN_RESOLUTION_DISTANCE = Distance.ONE_METER;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The waterway {0} does not end in a sink (ocean/sinkhole/waterway/drain).", "The waterway {0} loops back on itself. This is typically impossible.", "The waterway {0} crosses the waterway {1}.", "The waterway {0} probably does not go up hill.\nPlease check (source elevation data resolution was about {1} meters).", "The waterway {0} does not end in a sink (ocean/sinkhole/waterway/drain).\nThe waterway crosses a coastline, which means it is possible for the coastline to have an incorrect direction.\nLand should be to the LEFT of the coastline and the ocean should be to the RIGHT of the coastline (for more information, see https://wiki.osm.org/Tag:natural=coastline).");
    private final TaggableFilter waterwaySinkTagFilter;
    private final TaggableFilter waterwayTagFilter;
    private final TaggableFilter validOceanTags;
    private final TaggableFilter oceanBoundaryTags;
    private final ElevationUtilities elevationUtils;
    private final Distance minResolutionDistance;
    private final Distance minDistanceStartEndElevationUphill;

    public static Collection<Pair<Segment, Segment>> getIntersectingSegments(PolyLine left, PolyLine right) {
        HashSet<Pair<Segment, Segment>> intersectingSegments = new HashSet<Pair<Segment, Segment>>();
        for (Segment leftSegment : left.segments()) {
            for (Segment rightSegment : right.segments()) {
                if (!leftSegment.intersects(rightSegment)) continue;
                intersectingSegments.add((Pair<Segment, Segment>)Pair.of((Object)leftSegment, (Object)rightSegment));
            }
        }
        return intersectingSegments;
    }

    private static boolean endsWithBoundaryNode(Atlas atlas, AtlasObject object) {
        if (!(object instanceof LineItem)) {
            return false;
        }
        LineItem lineItem = (LineItem)object;
        Location last = lineItem.asPolyLine().last();
        Stream points = Iterables.asList((Iterable)atlas.pointsAt(last)).stream();
        Stream nodes = Iterables.asList((Iterable)atlas.nodesAt(last)).stream();
        return Stream.concat(points, nodes).anyMatch(SyntheticBoundaryNodeTag::isBoundaryNode);
    }

    public WaterWayCheck(Configuration configuration, ExternalDataFetcher fileFetcher) {
        super(configuration);
        this.elevationUtils = new ElevationUtilities(configuration, fileFetcher);
        this.waterwaySinkTagFilter = this.configurationValue(configuration, "waterway.sink.tags.filters", WATERWAY_SINK_TAG_FILTER_DEFAULT, TaggableFilter::forDefinition);
        this.waterwayTagFilter = this.configurationValue(configuration, "waterway.tags.filters", WATERWAY_TAG_FILTER_DEFAULT, TaggableFilter::forDefinition);
        this.validOceanTags = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "ocean.valid", "natural->strait,channel,fjord,sound,bay|harbour->*&harbour->!no|estuary->*&estuary->!no|bay->*&bay->!no|place->sea|seamark:type->harbour,harbour_basin,sea_area|water->bay,cove,harbour|waterway->artificial,dock"));
        this.oceanBoundaryTags = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "ocean.boundary", "natural->coastline"));
        this.minResolutionDistance = this.configurationValue(configuration, "waterway.elevation.resolution.min.uphill", MIN_RESOLUTION_DISTANCE.asMeters(), Distance::meters);
        this.minDistanceStartEndElevationUphill = this.configurationValue(configuration, "waterway.elevation.distance.min.start.end", Distance.FIFTEEN_HUNDRED_FEET.asMeters(), Distance::meters);
    }

    public boolean doesLineEndInOcean(Atlas atlas, LineItem line) {
        PolyLine linePolyline;
        block4: {
            block3: {
                linePolyline = line.asPolyLine();
                Location last = linePolyline.last();
                if (atlas.areasCovering(last, arg_0 -> ((TaggableFilter)this.validOceanTags).test(arg_0)).iterator().hasNext()) break block3;
                if (!atlas.areasCovering(last, arg_0 -> ((TaggableFilter)this.oceanBoundaryTags).test(arg_0)).iterator().hasNext()) break block4;
            }
            return true;
        }
        ArrayList lines = new ArrayList();
        atlas.lineItemsIntersecting((GeometricSurface)line.asPolyLine().bounds(), arg_0 -> ((TaggableFilter)this.oceanBoundaryTags).test(arg_0)).forEach(lines::add);
        LineItem[] intersecting = (LineItem[])lines.stream().filter(l -> l.asPolyLine().intersects(linePolyline)).toArray(LineItem[]::new);
        SegmentIndexComparator segmentComparator = new SegmentIndexComparator(linePolyline);
        for (LineItem lineItem : intersecting) {
            Collection<Pair<Segment, Segment>> segs = WaterWayCheck.getIntersectingSegments(linePolyline, lineItem.asPolyLine());
            Segment max = segs.stream().map(Pair::getKey).distinct().max(segmentComparator).orElse(null);
            Collection crosses = segs.stream().filter(pair -> ((Segment)pair.getLeft()).equals((Object)max)).map(Pair::getValue).collect(Collectors.toSet());
            PolyLine coast = new PolyLine((Location[])crosses.stream().flatMap(pCoast -> Stream.of(pCoast.first(), pCoast.last())).toArray(Location[]::new));
            if (!this.isRightOf(coast, linePolyline.last()) && !lineItem.asPolyLine().contains(linePolyline.last())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doesLineEndInSink(Atlas atlas, LineItem lineItem) {
        if (this.waterwaySinkTagFilter.test((Taggable)lineItem)) {
            return true;
        }
        Location last = lineItem.asPolyLine().last();
        Set nodes = Iterables.stream((Iterable)atlas.nodesAt(last)).filter(LocationItem.class::isInstance).map(LocationItem.class::cast).collectToSet();
        Set points = Iterables.stream((Iterable)atlas.pointsAt(last)).filter(LocationItem.class::isInstance).map(LocationItem.class::cast).collectToSet();
        if (Stream.concat(nodes.stream(), points.stream()).anyMatch(arg_0 -> ((TaggableFilter)this.waterwaySinkTagFilter).test(arg_0))) return true;
        if (!atlas.areasCovering(lineItem.asPolyLine().last(), arg_0 -> ((TaggableFilter)this.waterwaySinkTagFilter).test(arg_0)).iterator().hasNext()) return false;
        return true;
    }

    public boolean doesLineEndOnWaterway(Atlas atlas, LineItem line) {
        ArrayList<LineItem> waterways = new ArrayList<LineItem>();
        atlas.lineItemsContaining(line.asPolyLine().last(), arg_0 -> ((TaggableFilter)this.waterwayTagFilter).test(arg_0)).forEach(waterways::add);
        waterways.removeIf(arg_0 -> ((LineItem)line).equals(arg_0));
        Location last = line.asPolyLine().last();
        return waterways.stream().anyMatch(tLine -> tLine.asPolyLine().contains(last) && !last.equals((Object)tLine.asPolyLine().last()));
    }

    public boolean isRightOf(PolyLine line, Location location) {
        PolyLine tLine = new PolyLine((Iterable)location);
        Segment closest = line.segments().stream().min(Comparator.comparingDouble(s -> s.shortestDistanceTo(tLine).asMeters())).orElse(null);
        if (closest != null) {
            PolyLine testLine = new PolyLine(new Location[]{closest.first(), closest.last(), location});
            Angle difference = testLine.headingDifference().orElse(null);
            return difference != null && difference.asDegrees() > 0.0;
        }
        return false;
    }

    public boolean isValidEndToCheck(Atlas atlas, Location location) {
        return atlas.bounds().fullyGeometricallyEncloses(location);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object.getOsmIdentifier()) && object instanceof LineItem && this.waterwayTagFilter.test((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        LineItem line = (LineItem)object;
        Location last = line.asPolyLine().last();
        Location first = line.asPolyLine().first();
        Atlas atlas = line.getAtlas();
        CheckFlag flag = null;
        flag = this.flagCircularWaterway(flag, line);
        if (this.useExternalData()) {
            flag = this.flagIncline(flag, line, first, last);
        }
        flag = this.flagNoSink(flag, atlas, line, last);
        if ((flag = this.flagCrossingWays(flag, atlas, line)) != null) {
            super.markAsFlagged(object.getOsmIdentifier());
        }
        return Optional.ofNullable(flag);
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean doesLineCrossCoast(Atlas atlas, LineItem line) {
        ArrayList lines = new ArrayList();
        atlas.lineItemsIntersecting((GeometricSurface)line.asPolyLine().bounds(), arg_0 -> ((TaggableFilter)this.oceanBoundaryTags).test(arg_0)).forEach(lines::add);
        return !lines.isEmpty();
    }

    private boolean doesWaterwayEndInSink(Atlas atlas, LineItem line) {
        return this.doesLineEndOnWaterway(atlas, line) || this.doesLineEndInSink(atlas, line) || this.doesLineEndInOcean(atlas, line);
    }

    private CheckFlag flagCircularWaterway(CheckFlag flag, LineItem line) {
        if (line.isClosed()) {
            CheckFlag returnFlag = flag;
            String instructions = this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(CIRCULAR_WATERWAY), line.getOsmIdentifier());
            if (returnFlag == null) {
                returnFlag = this.createFlag((AtlasObject)line, instructions, Collections.singletonList(line.asPolyLine().first()));
            } else {
                returnFlag.addObject((AtlasObject)line, instructions);
            }
            return returnFlag;
        }
        return flag;
    }

    private CheckFlag flagCrossingWays(CheckFlag flag, Atlas atlas, LineItem line) {
        CheckFlag returnFlag = flag;
        Collection<LineItem> crossed = this.getIntersectingWaterways(atlas, line);
        for (LineItem lineItemCrossed : crossed) {
            Iterator intersections = lineItemCrossed.asPolyLine().intersections(line.asPolyLine()).iterator();
            if (!intersections.hasNext()) continue;
            String instruction = this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(CROSSES_WATERWAY), line.getOsmIdentifier(), lineItemCrossed.getOsmIdentifier());
            if (returnFlag == null) {
                returnFlag = this.createFlag((Set<AtlasObject>)Sets.hashSet((Object[])new LineItem[]{line, lineItemCrossed}), instruction, Arrays.asList((Location)intersections.next()));
                continue;
            }
            returnFlag.addObject((AtlasObject)lineItemCrossed, (Location)intersections.next(), instruction);
        }
        return returnFlag;
    }

    private CheckFlag flagIncline(CheckFlag flag, LineItem line, Location first, Location last) {
        boolean uphill;
        double incline = this.elevationUtils.getIncline(first, last);
        boolean bl = uphill = !Double.isNaN(incline) && incline > 0.0 && last.distanceTo(first).isGreaterThan(this.minDistanceStartEndElevationUphill);
        if (uphill && this.minResolutionDistance.isGreaterThanOrEqualTo(this.elevationUtils.getResolution(first))) {
            CheckFlag returnFlag = flag;
            String instruction = this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(GOES_UPHILL), line.getOsmIdentifier(), this.elevationUtils.getResolution(first).asMeters());
            if (returnFlag == null) {
                return this.createFlag((AtlasObject)line, instruction);
            }
            returnFlag.addInstruction(instruction);
            return returnFlag;
        }
        return flag;
    }

    private CheckFlag flagNoSink(CheckFlag flag, Atlas atlas, LineItem line, Location last) {
        if (this.isValidEndToCheck(atlas, last) && !this.doesWaterwayEndInSink(atlas, line) && !WaterWayCheck.endsWithBoundaryNode(atlas, (AtlasObject)line)) {
            CheckFlag returnFlag = flag;
            String instruction = this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(this.doesLineCrossCoast(atlas, line) ? DOES_NOT_END_IN_SINK_BUT_CROSSING_OCEAN : DOES_NOT_END_IN_SINK), line.getOsmIdentifier());
            if (returnFlag == null) {
                returnFlag = this.createFlag((AtlasObject)line, instruction, Collections.singletonList(last));
            } else {
                returnFlag.addObject((AtlasObject)line, last, instruction);
            }
            return returnFlag;
        }
        return flag;
    }

    private Collection<LineItem> getIntersectingWaterways(Atlas atlas, LineItem line) {
        PolyLine linePoly = line.asPolyLine();
        Iterable intersectingWaterways = atlas.lineItemsIntersecting((GeometricSurface)line.bounds(), lineItem -> this.waterwayTagFilter.test((Taggable)lineItem) && lineItem.asPolyLine().intersects(linePoly));
        Set sameLayerWays = Iterables.stream((Iterable)intersectingWaterways).filter(potential -> LayerTag.areOnSameLayer((Taggable)line, (Taggable)potential) && !this.waterwayConnects(line, (LineItem)potential)).collectToSet();
        sameLayerWays.removeIf(arg_0 -> ((LineItem)line).equals(arg_0));
        return sameLayerWays;
    }

    private boolean waterwayConnects(LineItem line, LineItem potential) {
        PolyLine linePoly = line.asPolyLine();
        PolyLine potentialPoly = potential.asPolyLine();
        Set locations = linePoly.intersections(potentialPoly);
        for (Location location : locations) {
            if (linePoly.contains(location) && potentialPoly.contains(location)) continue;
            return false;
        }
        return !locations.isEmpty();
    }

    private static class SegmentIndexComparator
    implements Comparator<Segment> {
        private final List<Segment> lineSegments;

        SegmentIndexComparator(PolyLine line) {
            this.lineSegments = line.segments();
        }

        @Override
        public int compare(Segment segment1, Segment segment2) {
            Segment segment1real = this.lineSegments.stream().filter(arg_0 -> ((Segment)segment1).equals(arg_0)).findFirst().orElse(null);
            Segment segment2real = this.lineSegments.stream().filter(arg_0 -> ((Segment)segment2).equals(arg_0)).findFirst().orElse(null);
            int segment1index = this.lineSegments.indexOf(segment1real);
            int segment2index = this.lineSegments.indexOf(segment2real);
            return segment1index - segment2index;
        }
    }
}

