/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.CommonMethods;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LevelTag;
import org.openstreetmap.atlas.tags.ManMadeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class OverlappingEdgeCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Duplicate Highway found for way id {0,number,#}. Overlapping way id(s) {1}.", "Way {0,number,#} wraps back on itself.");
    private static final long serialVersionUID = 606963380071388809L;
    private static final String HIGHWAY_MINIMUM_PRIORITY_DEFAULT = HighwayTag.RESIDENTIAL.toString();
    private static final boolean FILTER_PEDESTRIAN_AREAS_DEFAULT = true;
    private static final String ZERO = "0";
    private static final Predicate<Edge> AREA_YES_TAG = edge -> Validators.isOfType((Taggable)edge, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES});
    private final HighwayTag highwayMinimumPriority;
    private final boolean filterPedestrianAreas;

    private static Predicate<Edge> notEqual(AtlasObject object) {
        return edge -> !object.equals(edge);
    }

    public OverlappingEdgeCheck(Configuration configuration) {
        super(configuration);
        this.highwayMinimumPriority = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "highway.priority.minimum", HIGHWAY_MINIMUM_PRIORITY_DEFAULT).toUpperCase());
        this.filterPedestrianAreas = this.configurationValue(configuration, "pedestrian.areas.filter", true);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMainEdge() && (!this.filterPedestrianAreas || !this.edgeIsArea((Edge)object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Set<AtlasObject> overlappingItems;
        Set edges = new OsmWayWalker((Edge)object).collectEdges();
        if (!this.isFlagged(object.getIdentifier()) && !(overlappingItems = this.getOverlappingItems(object.getAtlas(), edges)).isEmpty()) {
            edges.forEach(edge -> this.markAsFlagged(edge.getIdentifier()));
            overlappingItems.forEach(overlapEdge -> this.markAsFlagged(overlapEdge.getIdentifier()));
            CheckFlag flag = this.createFlag(overlappingItems, this.getLocalizedInstruction(0, object.getOsmIdentifier(), new StringList(this.osmIdentifiers(overlappingItems)).join(", ")));
            if (overlappingItems.stream().anyMatch(overlapEdge -> overlapEdge.getOsmIdentifier() == object.getOsmIdentifier())) {
                flag.addInstruction(this.getLocalizedInstruction(1, object.getOsmIdentifier()));
            }
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean edgeIsArea(Edge edge) {
        return (Validators.isOfType((Taggable)edge, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.PEDESTRIAN}) || Validators.isOfType((Taggable)edge, ManMadeTag.class, (Enum[])new ManMadeTag[]{ManMadeTag.PIER})) && (AREA_YES_TAG.test(edge) || CommonMethods.isClosedWay(edge)) || Validators.isOfType((Taggable)edge, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.SERVICE}) && AREA_YES_TAG.test(edge);
    }

    private Set<AtlasObject> getOverlappingItems(Atlas atlas, Set<Edge> edges) {
        HashSet<AtlasObject> overlappingItems = new HashSet<AtlasObject>();
        for (Edge wayEdge : edges) {
            Location start = null;
            for (Location end : wayEdge.asPolyLine()) {
                if (start != null) {
                    Rectangle box = start.boxAround(Distance.meters((double)0.0));
                    overlappingItems.addAll(Iterables.stream((Iterable)atlas.edgesIntersecting((GeometricSurface)box, Edge::isMainEdge)).filter(OverlappingEdgeCheck.notEqual((AtlasObject)wayEdge).and(this.notIn((AtlasObject)wayEdge)).and(this.overlapsSegment(start, end)).and(this.filterPedestrianAreas ? edge -> !this.edgeIsArea((Edge)edge) : this.notPedestrianAreas(wayEdge)).and(this.haveSameLevels((AtlasObject)wayEdge))).collectToSet());
                }
                start = end;
            }
        }
        return overlappingItems;
    }

    private Predicate<Edge> haveSameLevels(AtlasObject object) {
        String objectLevel = LevelTag.getTaggedOrImpliedValue((Taggable)object, (String)ZERO);
        return edge -> {
            String edgeLevel = LevelTag.getTaggedOrImpliedValue((Taggable)edge, (String)ZERO);
            return objectLevel.equals(edgeLevel);
        };
    }

    private Predicate<Edge> notIn(AtlasObject object) {
        return edge -> !this.isFlagged(object.getIdentifier());
    }

    private Predicate<Edge> notPedestrianAreas(Edge object) {
        return edge -> {
            boolean edgeIsPedArea = this.edgeIsArea((Edge)edge);
            boolean objectIsPedArea = this.edgeIsArea(object);
            return !(edgeIsPedArea && objectIsPedArea || edgeIsPedArea && object.highwayTag().isLessImportantThan(this.highwayMinimumPriority) || objectIsPedArea && edge.highwayTag().isLessImportantThan(this.highwayMinimumPriority));
        };
    }

    private Iterable<String> osmIdentifiers(Iterable<AtlasObject> objects) {
        return Iterables.stream(objects).map(AtlasObject::getOsmIdentifier).map(String::valueOf).collectToList();
    }

    private Predicate<Edge> overlapsSegment(Location start, Location end) {
        return edge -> {
            PolyLine polyLine = edge.asPolyLine();
            return polyLine.contains(new Segment(start, end)) || polyLine.contains(new Segment(end, start));
        };
    }
}

