/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.PlaceTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Surface;

public class WaterbodyAndIslandSizeCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 4105386144665109331L;
    private static final String WATERBODY_INSTRUCTION = "Waterbody with OSM ID {0,number,#} has a surface area of {1,number,#.##} meters squared, which is outside of the expected surface area range of {2} square meters to {3} square kilometers.";
    private static final String ISLAND_INSTRUCTION = "Island with OSM ID {0,number,#} has a surface area of {1,number,#.##} meters squared, which is outside of the expected surface area range of {2} square meters to {3} square kilometers.";
    private static final String ISLET_INSTRUCTION = "Islet with OSM ID {0,number,#} has an surface area of {1,number,#.##} meters squared, which is outside of the expected surface area range of {2} square meters to {3} square kilometers. Islets greater than {3} square kilometers should likely be tagged as place=ISLAND.";
    private static final double WATERBODY_MIN_AREA_DEFAULT = 10.0;
    private static final double WATERBODY_MAX_AREA_DEFAULT = 337000.0;
    private static final double ISLAND_MIN_AREA_DEFAULT = 10.0;
    private static final double ISLAND_MAX_AREA_DEFAULT = 2170000.0;
    private static final double ISLET_MIN_AREA_DEFAULT = 10.0;
    private static final double ISLET_MAX_AREA_DEFAULT = 1.0;
    private static final Predicate<AtlasObject> IS_ISLET = object -> Validators.isOfType((Taggable)object, PlaceTag.class, (Enum[])new PlaceTag[]{PlaceTag.ISLET});
    private static final Predicate<AtlasObject> IS_ISLAND = object -> Validators.isOfType((Taggable)object, PlaceTag.class, (Enum[])new PlaceTag[]{PlaceTag.ISLAND, PlaceTag.ARCHIPELAGO});
    private static final String WATER_FEATURE_DEFAULT = "natural->lagoon||water->lagoon||waterway->lagoon||natural->spring,hot_spring&&name->*||natural->lake,pond,reservoir||landuse->pond,reservoir,basin||water->lake,pond,oxbow,salt_lake,reservoir||natural->water&&water->dam,Dam||natural->water&&seamark:type->dam||waterway->reservoir||water:type->lake||natural->stream||water->canal,river,lock,moat,riverbank,creek,stream,stream_pool||waterway->river,riverbank,brook,stream,creek,canal,derelict_canal||stream->*||waterway->drain,ditch&&name->*||water->drain,ditch&&name->*||natural->water&&water->!||waterway->water||water->water,Perennial||landuse->water||natural->tidalflat,reedbed&&seasonal->!||water->tidalflat,reedbed&&seasonal->!||wetland->tidalflat,reedbed&&seasonal->!&natural->!|||natural->*&&&natural->!dock,!water_point,!floodway,!spillway,!wastewater,!waterhole,!marsh,!swamp&&waterway->!|||waterway->*&&&waterway->!lock_gate,!dock,!water_point,!floodway,!spillway,!wastewater,!waterhole,!culvert,!dam,!waterfall,!fish_pass,!dry_dock,!construction,!boat_lift,!weir,!breakwater,!boatyard,!wetland&&water->!|||water->*&&&water->!lock_gate,!dock,!water_point,!floodway,!spillway,!wastewater,!waterhole,!pool,!reflecting_pool,!swimming_pool,!salt_pool,!fountain,!tank,!fish_pass,!estuary,!swamp,!tidal,!marsh,!wetland&&tunnel->!|||tunnel->*&&&tunnel->!culvert&&tunnel->!|||layer->!&&covered->!|||covered->*&&&covered->!yes&&waterway->!|||layer->!|||waterway->*&&&waterway->!drain&&&waterway->!ditch&&water->!|||layer->!|||water->*&&&water->!drain&&&water->!ditch&&wetland->!|||wetland->*&&&wetland->!swamp,!mangrove,!bog,!fen,!string_bog";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Waterbody with OSM ID {0,number,#} has a surface area of {1,number,#.##} meters squared, which is outside of the expected surface area range of {2} square meters to {3} square kilometers.", "Island with OSM ID {0,number,#} has a surface area of {1,number,#.##} meters squared, which is outside of the expected surface area range of {2} square meters to {3} square kilometers.", "Islet with OSM ID {0,number,#} has an surface area of {1,number,#.##} meters squared, which is outside of the expected surface area range of {2} square meters to {3} square kilometers. Islets greater than {3} square kilometers should likely be tagged as place=ISLAND.");
    private final TaggableFilter isWaterFeature;
    private final double waterbodyMinimumArea;
    private final double waterbodyMaximumArea;
    private final double islandMinimumArea;
    private final double islandMaximumArea;
    private final double isletMinimumArea;
    private final double isletMaximumArea;

    public WaterbodyAndIslandSizeCheck(Configuration configuration) {
        super(configuration);
        this.isWaterFeature = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "tags.waterFeature", WATER_FEATURE_DEFAULT));
        this.waterbodyMinimumArea = this.configurationValue(configuration, "surface.waterbody.minimum.meters", 10.0);
        this.waterbodyMaximumArea = this.configurationValue(configuration, "surface.waterbody.maximum.kilometers", 337000.0);
        this.islandMinimumArea = this.configurationValue(configuration, "surface.island.minimum.meters", 10.0);
        this.islandMaximumArea = this.configurationValue(configuration, "surface.island.maximum.kilometers", 2170000.0);
        this.isletMinimumArea = this.configurationValue(configuration, "surface.islet.minimum.meters", 10.0);
        this.isletMaximumArea = this.configurationValue(configuration, "surface.islet.maximum.kilometers", 1.0);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation && ((Relation)object).isMultiPolygon() && ((Relation)object).members().size() >= 2 && this.isWaterFeature.test((Taggable)object) || object instanceof Area && (this.isWaterFeature.test((Taggable)object) || IS_ISLET.test(object) || IS_ISLAND.test(object)) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Relation relation;
        Set<RelationMember> relationMembers;
        if (object instanceof Area) {
            Area area = (Area)object;
            Surface surfaceArea = area.asPolygon().surfaceOnSphere();
            double surfaceAreaMeters = surfaceArea.asMeterSquared();
            double surfaceAreaKilometers = surfaceArea.asKilometerSquared();
            this.markAsFlagged(area.getOsmIdentifier());
            if (this.isWaterFeature.test((Taggable)object) && (surfaceAreaMeters < this.waterbodyMinimumArea || surfaceAreaKilometers > this.waterbodyMaximumArea)) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), surfaceAreaMeters, this.waterbodyMinimumArea, this.waterbodyMaximumArea)));
            }
            if (IS_ISLAND.test(object) && (surfaceAreaMeters < this.islandMinimumArea || surfaceAreaKilometers > this.islandMaximumArea)) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(1, object.getOsmIdentifier(), surfaceAreaMeters, this.islandMinimumArea, this.islandMaximumArea)));
            }
            if (IS_ISLET.test(object) && (surfaceAreaMeters < this.isletMinimumArea || surfaceAreaKilometers > this.isletMaximumArea)) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(2, object.getOsmIdentifier(), surfaceAreaMeters, this.isletMinimumArea, this.isletMaximumArea)));
            }
        } else if (object instanceof Relation && !(relationMembers = (relation = (Relation)object).members().stream().filter(this::isValidMultiPolygonRelationMember).collect(Collectors.toSet())).isEmpty()) {
            return this.getMultiPolygonRelationFlags(relation, relationMembers);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<CheckFlag> getMultiPolygonRelationFlags(Relation relation, Set<RelationMember> relationMembers) {
        CheckFlag flag = new CheckFlag(this.getTaskIdentifier((AtlasObject)relation));
        for (RelationMember member : relationMembers) {
            Surface surfaceArea = ((Area)member.getEntity()).asPolygon().surfaceOnSphere();
            double surfaceAreaMeters = surfaceArea.asMeterSquared();
            double surfaceAreaKilometers = surfaceArea.asKilometerSquared();
            long memberOsmId = member.getEntity().getOsmIdentifier();
            this.markAsFlagged(memberOsmId);
            if (member.getRole().equals("inner") && (surfaceAreaMeters < this.islandMinimumArea || surfaceAreaKilometers > this.islandMaximumArea)) {
                flag.addInstruction(this.getLocalizedInstruction(1, memberOsmId, surfaceAreaMeters, this.islandMinimumArea, this.islandMaximumArea));
                flag.addObject((AtlasObject)member.getEntity());
            }
            if (!member.getRole().equals("outer") || !(surfaceAreaMeters < this.waterbodyMinimumArea) && !(surfaceAreaKilometers > this.waterbodyMaximumArea)) continue;
            flag.addInstruction(this.getLocalizedInstruction(0, memberOsmId, surfaceAreaMeters, this.waterbodyMinimumArea, this.waterbodyMaximumArea));
            flag.addObject((AtlasObject)member.getEntity());
        }
        return !flag.getFlaggedObjects().isEmpty() ? Optional.of(flag) : Optional.empty();
    }

    private boolean isValidMultiPolygonRelationMember(RelationMember member) {
        return member.getEntity() instanceof Area && !this.isFlagged(member.getEntity().getOsmIdentifier()) && (member.getRole().equals("outer") || member.getRole().equals("inner") && !Validators.isOfType((Taggable)member.getEntity(), NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.ROCK}));
    }
}

