/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag.serializer;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.flag.FlaggedRelation;
import org.openstreetmap.atlas.checks.flag.serializer.GeoJsonFeatureToAtlasEntityConverter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorName;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.converters.jts.JtsCoordinateArrayConverter;
import org.openstreetmap.atlas.geography.geojson.parser.GeoJsonParser;
import org.openstreetmap.atlas.geography.geojson.parser.domain.base.GeoJsonItem;
import org.openstreetmap.atlas.geography.geojson.parser.domain.feature.FeatureCollection;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.MultiPolygon;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.Point;
import org.openstreetmap.atlas.geography.geojson.parser.impl.jackson.GeoJsonParserJacksonImpl;

public class CheckFlagDeserializer
implements JsonDeserializer<CheckFlag> {
    private static final String PROPERTIES = "properties";
    private static final String GENERATOR = "generator";
    private static final String ID = "id";
    private static final String DESCRIPTORS = "descriptors";
    private static final String ITEM_TYPE = "itemType";
    private static final String ROLE = "role";
    private static final String POSITION = "position";
    private static final String AFTER_VIEW = "afterView";
    private static final GeoJsonParser GEOJSON_PARSER_JACKSON = GeoJsonParserJacksonImpl.INSTANCE;
    private static final Gson GSON = new Gson();
    private static final WKTReader WKT_READER = new WKTReader();
    private static final JtsCoordinateArrayConverter COORDINATE_ARRAY_CONVERTER = new JtsCoordinateArrayConverter();

    public static String parseIdentifiers(JsonArray identifiers) {
        return Arrays.stream((String[])new Gson().fromJson((JsonElement)identifiers, String[].class)).sorted().map(String::toString).collect(Collectors.joining(","));
    }

    public CheckFlag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject full = json.getAsJsonObject();
        if (full.get("type") == null) {
            return null;
        }
        JsonObject properties = full.get(PROPERTIES).getAsJsonObject();
        String checkName = properties.get(GENERATOR).getAsString();
        List<String> instructions = Arrays.stream(properties.get("instructions").getAsString().split("\n")).map(instruction -> instruction.replaceAll("^\\d+\\. ", "")).collect(Collectors.toList());
        String flagIdentifier = properties.get(ID).getAsString();
        CheckFlag flag = new CheckFlag(flagIdentifier);
        flag.addInstructions(instructions);
        flag.setChallengeName(checkName);
        GeoJsonItem geojsonItem = GEOJSON_PARSER_JACKSON.deserialize(GSON.toJson(json));
        if (!(geojsonItem instanceof FeatureCollection)) {
            return flag;
        }
        ((FeatureCollection)geojsonItem).getFeatures().forEach(feature -> {
            if (feature.getProperties().asMap().containsKey("synthetic_highlight_point") && feature.getGeometry() instanceof Point) {
                flag.addPoint(((Point)feature.getGeometry()).toAtlasGeometry());
            } else {
                GeoJsonFeatureToAtlasEntityConverter.convert(feature).ifPresent(entity -> {
                    if (entity instanceof Relation) {
                        flag.addObject(new FlaggedRelation((Relation)entity, ((MultiPolygon)feature.getGeometry()).toAtlasGeometry()));
                    } else {
                        flag.addObject((AtlasObject)entity);
                    }
                    if (full.has("fix_suggestions")) {
                        this.getFixSuggestion((AtlasEntity)entity, full.get("fix_suggestions").getAsJsonObject()).ifPresent(flag::addFixSuggestion);
                    }
                });
            }
        });
        return flag;
    }

    private void applyGeometryChanges(CompleteEntity<? extends AtlasEntity> afterView, List<JsonObject> descriptors) {
        ArrayList newGeometry = Lists.newArrayList((Iterable)afterView.getGeometry());
        descriptors.stream().sorted(Comparator.comparing(descriptor -> ChangeDescriptorType.valueOf((String)((JsonObject)descriptor).get("type").getAsString().toUpperCase())).thenComparingInt(descriptor -> Integer.valueOf(((JsonObject)descriptor).get(POSITION).getAsString().split("/")[0]))).forEach(descriptor -> {
            Integer position = Integer.valueOf(descriptor.get(POSITION).getAsString().split("/")[0]);
            switch (ChangeDescriptorType.valueOf((String)descriptor.get("type").getAsString().toUpperCase())) {
                case ADD: {
                    Lists.reverse(this.convertWktToLocations(descriptor.get(AFTER_VIEW).getAsString())).forEach(location -> newGeometry.add(position, location));
                    break;
                }
                case REMOVE: {
                    newGeometry.remove(position);
                    break;
                }
                case UPDATE: {
                    List<Location> updateLocations = this.convertWktToLocations(descriptor.get(AFTER_VIEW).getAsString());
                    for (int index = 0; index < updateLocations.size(); ++index) {
                        if (newGeometry.size() > position + index) {
                            newGeometry.set(position + index, updateLocations.get(index));
                            continue;
                        }
                        newGeometry.add(updateLocations.get(index));
                    }
                    break;
                }
            }
        });
        afterView.withGeometry((Iterable)newGeometry);
    }

    private void applyRelationMemberChange(CompleteEntity<? extends AtlasEntity> afterView, JsonObject descriptor) {
        if (afterView instanceof CompleteRelation) {
            RelationBean.RelationBeanItem member = new RelationBean.RelationBeanItem(Long.valueOf(descriptor.get(ID).getAsLong()), descriptor.get(ROLE).getAsString(), ItemType.valueOf((String)descriptor.get(ITEM_TYPE).getAsString().toUpperCase()));
            RelationBean bean = ((CompleteRelation)afterView).getBean();
            switch (ChangeDescriptorType.valueOf((String)descriptor.get("type").getAsString().toUpperCase())) {
                case ADD: {
                    bean.add(member);
                    ((CompleteRelation)afterView).withMembers(bean, ((CompleteRelation)afterView).bounds());
                    break;
                }
                case REMOVE: {
                    bean.removeItem(member);
                    ((CompleteRelation)afterView).withMembers(bean, ((CompleteRelation)afterView).bounds());
                    break;
                }
            }
        }
    }

    private void applyTagChange(CompleteEntity<? extends AtlasEntity> afterView, JsonObject descriptor) {
        String key = descriptor.get("key").getAsString();
        String value = descriptor.get("value").getAsString();
        switch (ChangeDescriptorType.valueOf((String)descriptor.get("type").getAsString().toUpperCase())) {
            case ADD: {
                afterView.withAddedTag(key, value);
                break;
            }
            case REMOVE: {
                afterView.withRemovedTag(key);
                break;
            }
            case UPDATE: {
                afterView.withReplacedTag(key, key, value);
                break;
            }
        }
    }

    private List<Location> convertWktToLocations(String wkt) {
        try {
            return Lists.newArrayList((Iterable)COORDINATE_ARRAY_CONVERTER.backwardConvert((CoordinateSequence)new CoordinateArraySequence(WKT_READER.read(wkt).getCoordinates())));
        }
        catch (ParseException parseException) {
            throw new CoreException("Cannot parse wkt : {}\nCaused by: ParseException {}", new Object[]{wkt, parseException.getMessage()});
        }
    }

    private Optional<FeatureChange> getFixSuggestion(AtlasEntity beforeView, JsonObject fixSuggestions) {
        String uniqueIdentifier = StringUtils.capitalize((String)beforeView.getType().toString().toLowerCase()).concat(String.valueOf(beforeView.getIdentifier()));
        if (!fixSuggestions.has(uniqueIdentifier)) {
            return Optional.empty();
        }
        JsonObject fixSuggestion = fixSuggestions.get(uniqueIdentifier).getAsJsonObject();
        ChangeDescriptorType suggestionType = ChangeDescriptorType.valueOf((String)fixSuggestion.get("type").getAsString().toUpperCase());
        if (ChangeDescriptorType.ADD.equals((Object)suggestionType)) {
            return Optional.empty();
        }
        if (ChangeDescriptorType.REMOVE.equals((Object)suggestionType)) {
            return Optional.of(new FeatureChange(ChangeType.REMOVE, CompleteEntity.shallowFrom((AtlasEntity)beforeView), beforeView));
        }
        CompleteEntity afterView = (CompleteEntity)CompleteEntity.from((AtlasEntity)beforeView);
        if (afterView.getType().equals((Object)ItemType.EDGE)) {
            ((CompleteEdge)afterView).withStartNodeIdentifier(null);
            ((CompleteEdge)afterView).withEndNodeIdentifier(null);
        }
        ArrayList<JsonObject> geometryChangeDescriptors = new ArrayList<JsonObject>();
        fixSuggestion.get(DESCRIPTORS).getAsJsonArray().forEach(descriptor -> {
            JsonObject descriptorObject = descriptor.getAsJsonObject();
            switch (ChangeDescriptorName.valueOf((String)descriptorObject.get("name").getAsString().toUpperCase())) {
                case TAG: {
                    this.applyTagChange((CompleteEntity<? extends AtlasEntity>)afterView, descriptorObject);
                    break;
                }
                case RELATION_MEMBER: {
                    this.applyRelationMemberChange((CompleteEntity<? extends AtlasEntity>)afterView, descriptorObject);
                    break;
                }
                case GEOMETRY: {
                    geometryChangeDescriptors.add(descriptorObject);
                    break;
                }
            }
        });
        if (!geometryChangeDescriptors.isEmpty()) {
            this.applyGeometryChanges((CompleteEntity<? extends AtlasEntity>)afterView, geometryChangeDescriptors);
        }
        return Optional.of(new FeatureChange(ChangeType.ADD, (AtlasEntity)afterView, beforeView));
    }
}

