/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;

public abstract class FlaggedObject
implements Serializable,
Located {
    public static final String ITEM_IDENTIFIER_TAG = "identifier";
    public static final String ITEM_TYPE_TAG = "itemType";
    public static final String OSM_IDENTIFIER_TAG = "osmIdentifier";
    public static final String COUNTRY_MISSING = "NA";
    protected static final String AREA_TAG = "Area";
    protected static final String EDGE_TAG = "Edge";
    protected static final String LINE_TAG = "Line";
    protected static final String NODE_TAG = "Node";
    protected static final String POINT_TAG = "Point";
    private static final long serialVersionUID = -2898518269816777421L;

    public abstract JsonObject asGeoJsonFeature(String var1);

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FlaggedObject)) {
            return false;
        }
        FlaggedObject otherObject = (FlaggedObject)other;
        return Objects.equals(this.getCountry(), otherObject.getCountry()) && Objects.equals(this.getGeometry(), otherObject.getGeometry()) && Objects.equals(this.getProperties(), otherObject.getProperties());
    }

    public abstract FlaggedObject getAsCompleteFlaggedObject();

    public String getCountry() {
        return COUNTRY_MISSING;
    }

    public abstract Iterable<Location> getGeometry();

    public abstract Map<String, String> getProperties();

    public String getUniqueIdentifier() {
        return this.getProperties().get(ITEM_TYPE_TAG) + this.getProperties().get(ITEM_IDENTIFIER_TAG);
    }

    public boolean hasCountry() {
        return !this.getCountry().equals(COUNTRY_MISSING);
    }

    public int hashCode() {
        return Objects.hash(this.getCountry(), this.getGeometry(), this.getProperties());
    }

    protected abstract Optional<AtlasObject> getObject();
}

