/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import com.google.common.base.CharMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class StreetNameIntegersOnlyCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 3439708862406928654L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Street {0,number,#} has a name containing only integers.");
    private static final List<String> NAME_KEYS_DEFAULT = Arrays.asList("name", "name:left", "name:right");
    private final List<String> nameKeys;
    private final boolean ignoreSingleCharacter;

    public StreetNameIntegersOnlyCheck(Configuration configuration) {
        super(configuration);
        this.nameKeys = this.configurationValue(configuration, "name.keys.filter", NAME_KEYS_DEFAULT);
        this.ignoreSingleCharacter = this.configurationValue(configuration, "character.single.ignore", false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validCheckForObject(AtlasObject object) {
        Map osmTags = object.getOsmTags();
        if (!(object instanceof Edge)) return false;
        if (!((Edge)object).isMasterEdge()) return false;
        if (!HighwayTag.isCarNavigableHighway((Taggable)object)) return false;
        if (!this.nameKeys.stream().anyMatch(osmTags::containsKey)) return false;
        return true;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        for (String nameKey : this.nameKeys) {
            Optional nameValue = object.getTag(nameKey);
            if (!nameValue.isPresent() || this.ignoreSingleCharacter && ((String)nameValue.get()).length() <= 1) continue;
            try {
                Integer.parseInt(CharMatcher.breakingWhitespace().replaceFrom((CharSequence)nameValue.get(), (CharSequence)""));
            }
            catch (NumberFormatException e) {
                continue;
            }
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

