/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Geometry;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.MultiplePolyLineToPolygonsConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.SyntheticRelationMemberAdded;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidMultiPolygonRelationCheck
extends BaseCheck<Long> {
    public static final int CLOSED_LOOP_INSTRUCTION_FORMAT_INDEX;
    public static final int INVALID_OSM_TYPE_INSTRUCTION_FORMAT_INDEX;
    public static final int INVALID_ROLE_INSTRUCTION_FORMAT_INDEX;
    public static final int MISSING_OUTER_INSTRUCTION_FORMAT_INDEX;
    public static final int SINGLE_MEMBER_RELATION_INSTRUCTION_FORMAT_INDEX;
    public static final int INVALID_OVERLAP_INSTRUCTION_FORMAT_INDEX;
    public static final int INNER_MISSING_OUTER_INSTRUCTION_FORMAT_INDEX;
    private static final String CLOSED_LOOP_INSTRUCTION_FORMAT = "The Multipolygon relation {0,number,#} with members : {1} is not closed at some locations : {2}";
    private static final String INVALID_OSM_TYPE_INSTRUCTION_FORMAT = "{0} relation member(s) are an invalid type in relation {1,number,#}. Multipolygon relations can only have ways as members. The first object id(s) are {2}";
    private static final String INVALID_ROLE_INSTRUCTION_FORMAT = "{0} ways have an invalid or missing role in multipolygon relation {1,number,#}. The role must be either outer or inner. The way id(s) are {2}";
    private static final String INVALID_OVERLAP_INSTRUCTION_FORMAT = "Relation {0,number,#} has members with centroids {1} & {2} that invalidly overlap.";
    private static final String INNER_MISSING_OUTER_INSTRUCTION_FORMAT = "Relation {0,number,#} has an inner member that is not contained by an outer member.";
    private static final String MISSING_OUTER_INSTRUCTION_FORMAT = "Multipolygon relation {0,number,#} has no outer member(s). Must have 1 or more.";
    private static final String SINGLE_MEMBER_RELATION_INSTRUCTION_FORMAT = "Multipolygon relation {0,number,#} has only one member.";
    private static final List<String> FALLBACK_INSTRUCTIONS;
    private static final RelationOrAreaToMultiPolygonConverter RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER;
    private static final EnumMap<ItemType, String> atlasToOsmType;
    private static final Logger logger;
    private static final JtsPolygonConverter JTS_POLYGON_CONVERTER;
    private final boolean ignoreOneMember;

    public InvalidMultiPolygonRelationCheck(Configuration configuration) {
        super(configuration);
        this.ignoreOneMember = this.configurationValue(configuration, "members.one.ignore", false);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation && Validators.isOfType((Taggable)object, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON}) && (!this.ignoreOneMember || ((Relation)object).members().size() != 1) && !SyntheticRelationMemberAdded.hasAddedRelationMember((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Relation multipolygonRelation = (Relation)object;
        ArrayList<String> instructions = new ArrayList<String>();
        HashSet<Location> issueLocations = new HashSet<Location>();
        this.checkGeometry(multipolygonRelation).ifPresent(tuple -> {
            instructions.addAll((Collection)tuple.getFirst());
            issueLocations.addAll((Collection)tuple.getSecond());
        });
        if (multipolygonRelation.members().size() <= 1) {
            instructions.add(this.getLocalizedInstruction(SINGLE_MEMBER_RELATION_INSTRUCTION_FORMAT_INDEX, multipolygonRelation.getOsmIdentifier()));
        }
        instructions.addAll(this.checkRolesAndTypes(multipolygonRelation));
        if (!instructions.isEmpty()) {
            CheckFlag flag = this.createFlag(object, instructions);
            flag.addPoints(issueLocations);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<Tuple<Set<String>, Set<Location>>> checkGeometry(Relation multipolygonRelation) {
        try {
            return Optional.of(this.checkOverlap(RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert((AtlasEntity)multipolygonRelation), multipolygonRelation.getOsmIdentifier()));
        }
        catch (MultiplePolyLineToPolygonsConverter.OpenPolygonException exception) {
            List openLocations = exception.getOpenLocations();
            Set objects = openLocations.stream().flatMap(location -> this.filterMembers(multipolygonRelation, (Location)location)).collect(Collectors.toSet());
            Set memberIds = multipolygonRelation.members().stream().map(member -> member.getEntity().getOsmIdentifier()).collect(Collectors.toSet());
            if (!objects.isEmpty() && !memberIds.isEmpty()) {
                return Optional.of(Tuple.createTuple(Collections.singleton(this.getLocalizedInstruction(CLOSED_LOOP_INSTRUCTION_FORMAT_INDEX, multipolygonRelation.getOsmIdentifier(), memberIds, openLocations)), new HashSet(openLocations)));
            }
            logger.warn("Unable to find members in multipolygonRelation {} containing the locations : {}", (Object)multipolygonRelation, (Object)openLocations);
        }
        catch (CoreException exception) {
            if (exception.getMessage().equals("Unable to find outer polygon.")) {
                return Optional.of(Tuple.createTuple(Collections.singleton(this.getLocalizedInstruction(MISSING_OUTER_INSTRUCTION_FORMAT_INDEX, multipolygonRelation.getOsmIdentifier())), Collections.emptySet()));
            }
            if (exception.getMessage().contains("Malformed MultiPolygon: inner has no outer host")) {
                return Optional.of(Tuple.createTuple(Collections.singleton(this.getLocalizedInstruction(INNER_MISSING_OUTER_INSTRUCTION_FORMAT_INDEX, multipolygonRelation.getOsmIdentifier())), Collections.emptySet()));
            }
            logger.warn("Unable to convert multipolygonRelation {}. {}", (Object)multipolygonRelation.getOsmIdentifier(), (Object)exception.getMessage());
        }
        catch (Exception exception) {
            logger.warn("Unable to convert multipolygonRelation {}. {}", (Object)multipolygonRelation.getOsmIdentifier(), (Object)exception.getMessage());
        }
        return Optional.empty();
    }

    private Set<Tuple<Polygon, Polygon>> checkInnerOverlap(MultiMap<Polygon, Polygon> outerToInners) {
        HashSet<Tuple<Polygon, Polygon>> problematicPolygons = new HashSet<Tuple<Polygon, Polygon>>();
        outerToInners.forEach((key, value) -> {
            for (int index1 = 0; index1 < value.size() - 1; ++index1) {
                for (int index2 = index1 + 1; index2 < value.size(); ++index2) {
                    org.locationtech.jts.geom.Polygon jtsPolygon2;
                    Polygon polygon1 = (Polygon)value.get(index1);
                    Polygon polygon2 = (Polygon)value.get(index2);
                    org.locationtech.jts.geom.Polygon jtsPolygon1 = JTS_POLYGON_CONVERTER.convert(polygon1);
                    if (!(Math.abs(jtsPolygon1.union((Geometry)(jtsPolygon2 = JTS_POLYGON_CONVERTER.convert(polygon2))).getArea() - (jtsPolygon1.getArea() + jtsPolygon2.getArea())) > 1.0E-7)) continue;
                    problematicPolygons.add(Tuple.createTuple((Object)polygon1, (Object)polygon2));
                }
            }
            value.stream().filter(polygon -> polygon.intersects((PolyLine)key)).forEach(polygon -> problematicPolygons.add(Tuple.createTuple((Object)polygon, (Object)key)));
        });
        return problematicPolygons;
    }

    private Set<Tuple<Polygon, Polygon>> checkOuterOverlap(MultiMap<Polygon, Polygon> outerToInners) {
        HashSet<Tuple<Polygon, Polygon>> problematicPolygons = new HashSet<Tuple<Polygon, Polygon>>();
        ArrayList outersList = new ArrayList(outerToInners.keySet());
        for (int index1 = 0; index1 < outersList.size() - 1; ++index1) {
            for (int index2 = index1 + 1; index2 < outersList.size(); ++index2) {
                Polygon polygon2;
                Polygon polygon1 = (Polygon)outersList.get(index1);
                if (!polygon1.overlaps((PolyLine)(polygon2 = (Polygon)outersList.get(index2))) || polygon1.fullyGeometricallyEncloses((PolyLine)polygon2) && outerToInners.get((Object)polygon1).stream().anyMatch(inner -> inner.fullyGeometricallyEncloses((PolyLine)polygon2)) || polygon2.fullyGeometricallyEncloses((PolyLine)polygon1) && outerToInners.get((Object)polygon2).stream().anyMatch(inner -> inner.fullyGeometricallyEncloses((PolyLine)polygon1))) continue;
                problematicPolygons.add((Tuple<Polygon, Polygon>)Tuple.createTuple((Object)polygon1, (Object)polygon2));
            }
        }
        return problematicPolygons;
    }

    private Tuple<Set<String>, Set<Location>> checkOverlap(MultiPolygon multiPolygon, Long osmIdentifier) {
        HashSet<Tuple<Polygon, Polygon>> problematicPolygons = new HashSet<Tuple<Polygon, Polygon>>();
        MultiMap outerToInners = multiPolygon.getOuterToInners();
        problematicPolygons.addAll(this.checkOuterOverlap((MultiMap<Polygon, Polygon>)outerToInners));
        problematicPolygons.addAll(this.checkInnerOverlap((MultiMap<Polygon, Polygon>)outerToInners));
        HashSet instructions = new HashSet();
        HashSet locations = new HashSet();
        problematicPolygons.forEach(tuple -> {
            Location firstCentroid = ((Polygon)tuple.getFirst()).center();
            Location secondCentroid = ((Polygon)tuple.getFirst()).center();
            instructions.add(this.getLocalizedInstruction(INVALID_OVERLAP_INSTRUCTION_FORMAT_INDEX, osmIdentifier, firstCentroid.toCompactString(), secondCentroid.toCompactString()));
            locations.add(firstCentroid);
            locations.add(secondCentroid);
        });
        return Tuple.createTuple(instructions, locations);
    }

    private Set<String> checkRolesAndTypes(Relation multipolygonRelation) {
        HashSet<String> instructions = new HashSet<String>();
        LinkedHashSet<Long> invalidRoleIDs = new LinkedHashSet<Long>();
        LinkedHashSet<Tuple> invalidTypeIDs = new LinkedHashSet<Tuple>();
        for (RelationMember relationMember : multipolygonRelation.members()) {
            if (!atlasToOsmType.get(relationMember.getEntity().getType()).equals("way")) {
                invalidTypeIDs.add(Tuple.createTuple((Object)atlasToOsmType.get(relationMember.getEntity().getType()), (Object)relationMember.getEntity().getOsmIdentifier()));
                continue;
            }
            if (relationMember.getRole().equals("outer") || relationMember.getRole().equals("inner")) continue;
            invalidRoleIDs.add(relationMember.getEntity().getOsmIdentifier());
        }
        if (!invalidRoleIDs.isEmpty()) {
            instructions.add(this.getLocalizedInstruction(INVALID_ROLE_INSTRUCTION_FORMAT_INDEX, invalidRoleIDs.size(), multipolygonRelation.getOsmIdentifier(), invalidRoleIDs));
        }
        if (!invalidTypeIDs.isEmpty()) {
            instructions.add(this.getLocalizedInstruction(INVALID_OSM_TYPE_INSTRUCTION_FORMAT_INDEX, invalidTypeIDs.size(), multipolygonRelation.getOsmIdentifier(), invalidTypeIDs));
        }
        return instructions;
    }

    private Stream<Line> filterMembers(Relation relation, Location location) {
        return relation.members().stream().map(RelationMember::getEntity).filter(entity -> entity instanceof Line).map(entity -> (Line)entity).filter(line -> line.asPolyLine().contains(location));
    }

    static {
        FALLBACK_INSTRUCTIONS = Arrays.asList(CLOSED_LOOP_INSTRUCTION_FORMAT, SINGLE_MEMBER_RELATION_INSTRUCTION_FORMAT, MISSING_OUTER_INSTRUCTION_FORMAT, INVALID_ROLE_INSTRUCTION_FORMAT, INVALID_OSM_TYPE_INSTRUCTION_FORMAT, INVALID_OVERLAP_INSTRUCTION_FORMAT, INNER_MISSING_OUTER_INSTRUCTION_FORMAT);
        RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
        atlasToOsmType = new EnumMap(ItemType.class);
        logger = LoggerFactory.getLogger(InvalidMultiPolygonRelationCheck.class);
        JTS_POLYGON_CONVERTER = new JtsPolygonConverter();
        INVALID_ROLE_INSTRUCTION_FORMAT_INDEX = FALLBACK_INSTRUCTIONS.indexOf(INVALID_ROLE_INSTRUCTION_FORMAT);
        MISSING_OUTER_INSTRUCTION_FORMAT_INDEX = FALLBACK_INSTRUCTIONS.indexOf(MISSING_OUTER_INSTRUCTION_FORMAT);
        SINGLE_MEMBER_RELATION_INSTRUCTION_FORMAT_INDEX = FALLBACK_INSTRUCTIONS.indexOf(SINGLE_MEMBER_RELATION_INSTRUCTION_FORMAT);
        CLOSED_LOOP_INSTRUCTION_FORMAT_INDEX = FALLBACK_INSTRUCTIONS.indexOf(CLOSED_LOOP_INSTRUCTION_FORMAT);
        INVALID_OSM_TYPE_INSTRUCTION_FORMAT_INDEX = FALLBACK_INSTRUCTIONS.indexOf(INVALID_OSM_TYPE_INSTRUCTION_FORMAT);
        INVALID_OVERLAP_INSTRUCTION_FORMAT_INDEX = FALLBACK_INSTRUCTIONS.indexOf(INVALID_OVERLAP_INSTRUCTION_FORMAT);
        INNER_MISSING_OUTER_INSTRUCTION_FORMAT_INDEX = FALLBACK_INSTRUCTIONS.indexOf(INNER_MISSING_OUTER_INSTRUCTION_FORMAT);
        atlasToOsmType.put(ItemType.EDGE, "way");
        atlasToOsmType.put(ItemType.AREA, "way");
        atlasToOsmType.put(ItemType.LINE, "way");
        atlasToOsmType.put(ItemType.NODE, "node");
        atlasToOsmType.put(ItemType.POINT, "node");
        atlasToOsmType.put(ItemType.RELATION, "relation");
    }
}

