/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public class SnakeRoadNetworkWalk {
    private boolean isSnakeRoad = false;
    private final Optional<String> roadName;
    private final Optional<String> refTag;
    private long greatestEncounteredValence;
    private final TreeSet<AtlasObject> visitedEdges;
    private final Angle edgeHeadingDifferenceThreshold;
    private final Queue<Edge> directConnections;
    private final Set<Edge> oneLayerRemovedConnections;

    protected SnakeRoadNetworkWalk(Edge edge, Angle threshold) {
        this.roadName = edge.getTag("name");
        this.refTag = edge.getTag("ref");
        this.greatestEncounteredValence = 0L;
        this.visitedEdges = new TreeSet((one, two) -> Long.compare(one.getIdentifier(), two.getIdentifier()));
        this.visitedEdges.add((AtlasObject)edge);
        this.directConnections = new LinkedList<Edge>();
        this.oneLayerRemovedConnections = new HashSet<Edge>();
        this.edgeHeadingDifferenceThreshold = threshold;
    }

    protected void addDirectConnections(Set<Edge> edges) {
        this.directConnections.addAll(edges);
    }

    protected void checkIfEdgeHeadingDifferenceExceedsThreshold(Edge incoming, Edge outgoing) {
        if (!this.isSnakeRoad()) {
            Optional incomingHeading = incoming.overallHeading();
            Optional outgoingHeading = outgoing.overallHeading();
            if (incomingHeading.isPresent() && outgoingHeading.isPresent() && ((Heading)incomingHeading.get()).difference((Angle)outgoingHeading.get()).isGreaterThanOrEqualTo(this.edgeHeadingDifferenceThreshold)) {
                this.setSnakeRoadStatus(true);
            }
        }
    }

    protected void clearOneLayerRemovedConnections() {
        this.oneLayerRemovedConnections.clear();
    }

    protected void filterFalsePositives() {
        if (this.isSnakeRoad() && (this.hasRoadName() || this.hasRefTag())) {
            HashSet<Edge> connections = new HashSet<Edge>();
            connections.addAll(this.getMasterEdgesForConnectedEdgesOfDifferentWays((Edge)this.getVisitedEdges().first()));
            connections.addAll(this.getMasterEdgesForConnectedEdgesOfDifferentWays((Edge)this.getVisitedEdges().last()));
            for (Edge connection : connections) {
                Optional connectionName = connection.getTag("name");
                Optional refTag = connection.getTag("ref");
                if (!connectionName.equals(this.getRoadName()) && !refTag.equals(this.getRefTag())) continue;
                this.setSnakeRoadStatus(false);
                break;
            }
        }
    }

    protected Set<Edge> getConnectedMasterEdgeOfTheSameWay(Edge edge) {
        return edge.connectedEdges().stream().filter(connection -> connection.isMasterEdge() && connection.getOsmIdentifier() == edge.getOsmIdentifier() && !this.visitedEdges.contains(connection)).collect(Collectors.toSet());
    }

    protected Queue<Edge> getDirectConnections() {
        return this.directConnections;
    }

    protected long getGreatestEncounteredValence() {
        return this.greatestEncounteredValence;
    }

    protected Set<Edge> getOneLayerRemovedConnections() {
        return this.oneLayerRemovedConnections;
    }

    protected TreeSet<AtlasObject> getVisitedEdges() {
        return this.visitedEdges;
    }

    protected boolean isSnakeRoad() {
        return this.isSnakeRoad;
    }

    protected void populateOneLayerRemovedConnections(Set<Edge> edges) {
        this.oneLayerRemovedConnections.addAll(edges);
    }

    protected void visitEdge(Edge comingFrom, Edge comingTo) {
        this.visitedEdges.add((AtlasObject)comingTo);
        this.setGreatestValence(comingTo.start());
        this.setGreatestValence(comingTo.end());
    }

    private Set<Edge> getMasterEdgesForConnectedEdgesOfDifferentWays(Edge edge) {
        return Iterables.stream((Iterable)edge.connectedEdges()).filter(candidate -> candidate.isMasterEdge() && candidate.getOsmIdentifier() != edge.getOsmIdentifier()).collectToSet();
    }

    private Optional<String> getRefTag() {
        return this.refTag;
    }

    private Optional<String> getRoadName() {
        return this.roadName;
    }

    private boolean hasRefTag() {
        return this.refTag.isPresent();
    }

    private boolean hasRoadName() {
        return this.roadName.isPresent();
    }

    private void setGreatestValence(Node node) {
        long valence = node.valence();
        if (valence > this.greatestEncounteredValence) {
            this.greatestEncounteredValence = valence;
        }
    }

    private void setSnakeRoadStatus(boolean value) {
        this.isSnakeRoad = value;
    }
}

