/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.BigNode;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.BigNodeFinder;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class BigNodeBadDataCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This complex intersection has too many junction edges ({0}).", "This complex intersection has too many paths ({0}).  There are {1,number,#} restricted paths and their OSM ids are: {2} ");
    private static final long MAX_NUMBER_JUNCTION_EDGES_THRESHOLD_DEFAULT = 12L;
    private static final long MAX_NUMBER_PATHS_THRESHOLD_DEFAULT = 1000L;
    private static final String MINIMUM_HIGHWAY_TYPE_DEFAULT = HighwayTag.TOLL_GANTRY.toString();
    private static final String MAXIMUM_HIGHWAY_TYPE_DEFAULT = HighwayTag.MOTORWAY.toString();
    private static final long serialVersionUID = 6311899117562612121L;
    private final long maxNumberJunctionEdgesThreshold;
    private final long maxNumberPathsThreshold;
    private final HighwayTag minimumHighwayType;
    private final HighwayTag maximumHighwayType;

    public BigNodeBadDataCheck(Configuration configuration) {
        super(configuration);
        this.maxNumberPathsThreshold = this.configurationValue(configuration, "max.number.paths.threshold", 1000L);
        this.maxNumberJunctionEdgesThreshold = this.configurationValue(configuration, "max.number.junction.edges.threshold", 12L);
        this.minimumHighwayType = this.configurationValue(configuration, "highway.type.minimum", MINIMUM_HIGHWAY_TYPE_DEFAULT, configValue -> HighwayTag.valueOf((String)configValue.toUpperCase()));
        this.maximumHighwayType = this.configurationValue(configuration, "highway.type.maximum", MAXIMUM_HIGHWAY_TYPE_DEFAULT, configValue -> HighwayTag.valueOf((String)configValue.toUpperCase()));
    }

    @Override
    public Optional<Finder> finder() {
        return Optional.of(new BigNodeFinder());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof BigNode;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        BigNode bigNode = (BigNode)object;
        if (this.containsNonPriorityHighways(bigNode)) {
            return Optional.empty();
        }
        int junctionEdgesCount = bigNode.junctionEdges().size();
        if ((long)junctionEdgesCount > this.maxNumberJunctionEdgesThreshold) {
            CheckFlag flag = this.createFlag((AtlasObject)bigNode, this.getLocalizedInstruction(0, junctionEdgesCount));
            bigNode.edges().forEach(flag::addObject);
            bigNode.nodes().forEach(b -> flag.addPoint(b.getLocation()));
            return Optional.of(flag);
        }
        int allPathsCount = bigNode.allPaths().size();
        Set turnRestrictions = bigNode.turnRestrictions();
        int turnRestrictionCount = turnRestrictions.size();
        List restrictedPathOsmIds = turnRestrictions.stream().flatMap(restrictedPath -> Iterables.asList((Iterable)restrictedPath.getRoute()).stream().map(AtlasEntity::getOsmIdentifier)).collect(Collectors.toList());
        if ((long)allPathsCount > this.maxNumberPathsThreshold) {
            CheckFlag flag = this.createFlag((AtlasObject)bigNode, this.getLocalizedInstruction(1, allPathsCount, turnRestrictionCount, restrictedPathOsmIds.toString()));
            bigNode.edges().forEach(flag::addObject);
            bigNode.nodes().forEach(b -> flag.addPoint(b.getLocation()));
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean containsNonPriorityHighways(BigNode bigNode) {
        return bigNode.edges().stream().anyMatch(edge -> !HighwayTag.highwayTag((Taggable)edge).isPresent() || !((HighwayTag)HighwayTag.highwayTag((Taggable)edge).get()).isMoreImportantThanOrEqualTo(this.minimumHighwayType) || !((HighwayTag)HighwayTag.highwayTag((Taggable)edge).get()).isLessImportantThanOrEqualTo(this.maximumHighwayType));
    }
}

