/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Triple;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.tags.BuildingPartTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class SpikyBuildingCheck
extends BaseCheck<Long> {
    private static final double DEFAULT_MIN_HEADING_THRESHOLD = 15.0;
    private static final double DEFAULT_CIRCULAR_ANGLE_THRESHOLD = 25.0;
    private static final double DEFAULT_MINIMUM_TOTAL_CIRCULAR_ANGLE_THRESHOLD = 10.0;
    private static final long DEFAULT_MINIMUM_CIRCULAR_POINTS = 4L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("There are sharp angles ({0} degrees, which is less than the threshold of {1} degrees) in this building's geometry. This may be a result of poor digitization.");
    private static final long serialVersionUID = 4855581831899813303L;
    private final Angle headingThreshold;
    private final Angle circularAngleThreshold;
    private final Angle minimumTotalCircularAngleThreshold;
    private final long minimumCircularPointsInCurve;

    public SpikyBuildingCheck(Configuration configuration) {
        super(configuration);
        this.headingThreshold = this.configurationValue(configuration, "spiky.angle.maximum", 15.0, Angle::degrees);
        this.circularAngleThreshold = this.configurationValue(configuration, "curve.degrees.maximum.single_heading_change", 25.0, Angle::degrees);
        this.minimumTotalCircularAngleThreshold = this.configurationValue(configuration, "curve.degrees.minimum.total_heading_change", 10.0, Angle::degrees);
        this.minimumCircularPointsInCurve = this.configurationValue(configuration, "curve.points.minimum", 4L);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return (object instanceof Area || object instanceof Relation && ((Relation)object).isMultiPolygon()) && this.isBuildingOrPart(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        List allSpikyAngles = this.getPolygons(object).map(this::getSpikyAngleLocations).filter(angleLocations -> !angleLocations.isEmpty()).flatMap(Collection::stream).collect(Collectors.toList());
        if (!allSpikyAngles.isEmpty()) {
            String instruction = this.getLocalizedInstruction(0, allSpikyAngles.stream().map(Tuple::getFirst).map(Angle::toString).collect(Collectors.joining(", ")), this.headingThreshold.toString());
            List<Location> markers = allSpikyAngles.stream().map(Tuple::getSecond).collect(Collectors.toList());
            CheckFlag flag = object instanceof Area ? this.createFlag(object, instruction, markers) : this.createFlag((Set<AtlasObject>)((Relation)object).flatten(), instruction, markers);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Set<Location> getCurvedLocations(List<Segment> segments) {
        List<Triple<Integer, Segment, Segment>> curvedSections = this.summarizeCurvedSections(this.getPotentiallyCircularPoints(segments)).stream().filter(segment -> (long)((Integer)segment.getLeft()).intValue() >= this.minimumCircularPointsInCurve).filter(segment -> this.getDifferenceInHeadings((Segment)segment.getMiddle(), (Segment)segment.getRight(), Angle.MINIMUM).isGreaterThanOrEqualTo(this.minimumTotalCircularAngleThreshold)).collect(Collectors.toList());
        return this.sectionsToLocations(curvedSections, segments);
    }

    private Angle getDifferenceInHeadings(Segment firstSegment, Segment secondSegment, Angle defaultAngle) {
        return firstSegment.heading().flatMap(first -> secondSegment.heading().map(arg_0 -> ((Heading)first).difference(arg_0))).orElse(defaultAngle);
    }

    private Stream<Polygon> getPolygons(AtlasObject object) {
        if (object instanceof Area) {
            return Stream.of(((Area)object).asPolygon());
        }
        if (((Relation)object).isMultiPolygon()) {
            return ((Relation)object).members().stream().map(this::toPolygon).flatMap(optPoly -> optPoly.map(Stream::of).orElse(Stream.empty()));
        }
        return Stream.empty();
    }

    private List<Tuple<Segment, Segment>> getPotentiallyCircularPoints(List<Segment> segments) {
        return this.segmentPairsFrom(segments).filter(segmentTuple -> this.getDifferenceInHeadings((Segment)segmentTuple.getFirst(), (Segment)segmentTuple.getSecond(), Angle.MAXIMUM).isLessThan(this.circularAngleThreshold)).collect(Collectors.toList());
    }

    private Optional<Tuple<Angle, Location>> getSpikyAngleLocation(Segment beforeAngle, Segment afterAngle, Set<Location> curvedLocations) {
        Angle difference;
        if (!curvedLocations.contains(afterAngle.end()) && !curvedLocations.contains(beforeAngle.start()) && (difference = this.getDifferenceInHeadings(beforeAngle, afterAngle.reversed(), Angle.MAXIMUM)).isLessThan(this.headingThreshold)) {
            return Optional.of(Tuple.createTuple((Object)difference, (Object)afterAngle.start()));
        }
        return Optional.empty();
    }

    private List<Tuple<Angle, Location>> getSpikyAngleLocations(Polygon polygon) {
        List segments = polygon.segments();
        Set<Location> curvedLocations = this.getCurvedLocations(segments);
        return this.segmentPairsFrom(segments).map(segmentPair -> this.getSpikyAngleLocation((Segment)segmentPair.getFirst(), (Segment)segmentPair.getSecond(), curvedLocations)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private boolean isBuildingOrPart(AtlasObject object) {
        return BuildingTag.isBuilding((Taggable)object) || Validators.isNotOfType((Taggable)object, BuildingPartTag.class, (Enum[])new BuildingPartTag[]{BuildingPartTag.NO});
    }

    private Set<Location> sectionsToLocations(List<Triple<Integer, Segment, Segment>> curvedSections, List<Segment> allSegments) {
        if (curvedSections.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Location> locations = new HashSet<Location>();
        boolean inMiddleOfSegment = false;
        int curvedSectionIndex = 0;
        Segment curvedSectionStart = (Segment)curvedSections.get(curvedSectionIndex).getMiddle();
        Segment curvedSectionEnd = (Segment)curvedSections.get(curvedSectionIndex).getRight();
        for (Tuple beforeAndAfter : this.segmentPairsFrom(allSegments).collect(Collectors.toList())) {
            if (inMiddleOfSegment) {
                if (curvedSectionEnd.equals(beforeAndAfter.getSecond())) {
                    inMiddleOfSegment = false;
                    locations.add(curvedSectionEnd.start());
                    if (++curvedSectionIndex >= curvedSections.size()) break;
                    curvedSectionStart = (Segment)curvedSections.get(curvedSectionIndex).getMiddle();
                    curvedSectionEnd = (Segment)curvedSections.get(curvedSectionIndex).getRight();
                    continue;
                }
                locations.add(((Segment)beforeAndAfter.getFirst()).end());
                continue;
            }
            if (!curvedSectionStart.equals(beforeAndAfter.getFirst())) continue;
            inMiddleOfSegment = true;
            locations.add(curvedSectionStart.end());
        }
        return locations;
    }

    private Stream<Tuple<Segment, Segment>> segmentPairsFrom(List<Segment> segments) {
        return Stream.concat(IntStream.range(1, segments.size()).mapToObj(secondIndex -> Tuple.createTuple((Object)((Segment)segments.get(secondIndex - 1)), (Object)((Segment)segments.get(secondIndex)))), Stream.of(Tuple.createTuple((Object)segments.get(segments.size() - 1), (Object)segments.get(0))));
    }

    private List<Triple<Integer, Segment, Segment>> summarizeCurvedSections(List<Tuple<Segment, Segment>> curvedLocations) {
        if (curvedLocations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Triple<Integer, Segment, Segment>> summaryStats = new ArrayList<Triple<Integer, Segment, Segment>>();
        Tuple<Segment, Segment> start = curvedLocations.get(0);
        Tuple<Segment, Segment> previous = curvedLocations.get(0);
        int numPoints = 1;
        for (Tuple<Segment, Segment> location : curvedLocations.subList(1, curvedLocations.size())) {
            if (!((Segment)previous.getSecond()).equals(location.getFirst())) {
                summaryStats.add(Triple.of((Object)numPoints, (Object)((Segment)start.getFirst()), (Object)((Segment)previous.getSecond())));
                numPoints = 1;
                start = location;
            } else {
                ++numPoints;
            }
            previous = location;
        }
        summaryStats.add(Triple.of((Object)numPoints, (Object)((Segment)start.getFirst()), (Object)((Segment)previous.getSecond())));
        if (((Segment)((Triple)summaryStats.get(0)).getMiddle()).equals(((Triple)summaryStats.get(summaryStats.size() - 1)).getRight())) {
            Triple first = (Triple)summaryStats.get(0);
            Triple last = (Triple)summaryStats.get(0);
            summaryStats.set(0, (Triple<Integer, Segment, Segment>)Triple.of((Object)((Integer)first.getLeft() + (Integer)last.getLeft()), (Object)((Segment)last.getMiddle()), (Object)((Segment)first.getRight())));
        }
        return summaryStats;
    }

    private Optional<Polygon> toPolygon(RelationMember member) {
        if (member.getEntity().getType().equals((Object)ItemType.AREA)) {
            return Optional.of(((Area)member.getEntity()).asPolygon());
        }
        return Optional.empty();
    }
}

