/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.tags.LeisureTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class PoolSizeCheck
extends BaseCheck<Long> {
    public static final double MAXIMUM_SIZE_DEFAULT = 5000000.0;
    public static final double MINIMUM_SIZE_DEFAULT = 5.0;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The swimming pool with OSM ID {0,number,#} with a surface area of {1,number,#.##} meters squared is greater than the expected maximum of {2} meters squared.", "The swimming pool with OSM ID {0,number,#} with a surface area of {1,number,#.##} meters squared is smaller than the expected minimum of {2} meters squared.");
    private static final long serialVersionUID = 1L;
    private final double maximumSize;
    private final double minimumSize;

    public PoolSizeCheck(Configuration configuration) {
        super(configuration);
        this.maximumSize = this.configurationValue(configuration, "surface.maximum", 5000000.0);
        this.minimumSize = this.configurationValue(configuration, "surface.minimum", 5.0);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area area = (Area)object;
        if (Validators.isOfType((Taggable)object, LeisureTag.class, (Enum[])new LeisureTag[]{LeisureTag.SWIMMING_POOL})) {
            double surfaceArea = area.asPolygon().surface().asMeterSquared();
            if (surfaceArea > this.maximumSize) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), surfaceArea, this.maximumSize)));
            }
            if (surfaceArea < this.minimumSize) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(1, object.getOsmIdentifier(), surfaceArea, this.minimumSize)));
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

