/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;
import org.openstreetmap.atlas.streaming.resource.File;

public final class FileUtility {
    private static final String LOG_EXTENSION = "log";
    private static final String ZIPPED_LOG_EXTENSION = ".log.gz";

    public static Optional<LogOutputFileType> getOptionalLogOutputType(File logFile) {
        if (logFile.getName().endsWith(ZIPPED_LOG_EXTENSION)) {
            return Optional.of(LogOutputFileType.COMPRESSED_LOG);
        }
        if (FilenameUtils.getExtension((String)logFile.getName()).equals(LOG_EXTENSION)) {
            return Optional.of(LogOutputFileType.LOG);
        }
        return Optional.empty();
    }

    public static BufferedReader getReader(File inputFile, LogOutputFileType fileType) throws IOException {
        if (fileType == LogOutputFileType.LOG) {
            return new BufferedReader(new FileReader(inputFile.getPath()));
        }
        return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(inputFile.getPath()))));
    }

    private FileUtility() {
    }

    public static enum LogOutputFileType {
        LOG,
        COMPRESSED_LOG;

    }
}

