/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;

public class TaskDeserializer
implements JsonDeserializer<Task> {
    private static final String PROPERTIES = "properties";
    private static final String GENERATOR = "generator";
    private static final String INSTRUCTIONS = "instructions";
    private static final String ID = "id";
    private static final String FEATURES = "features";
    private static final String GEOMETRY = "geometry";
    private static final String COORDINATES = "coordinates";
    private final String projectName;

    public TaskDeserializer(String projectName) {
        this.projectName = projectName;
    }

    public Task deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject full = json.getAsJsonObject();
        JsonObject properties = full.get(PROPERTIES).getAsJsonObject();
        String challengeName = properties.get(GENERATOR).getAsString();
        String instruction = properties.get(INSTRUCTIONS).getAsString();
        String taskID = properties.get(ID).getAsString();
        JsonArray geojson = full.get(FEATURES).getAsJsonArray();
        Task result = new Task();
        result.setChallengeName(challengeName);
        result.setPoints(this.getPointsFromGeojson(geojson));
        result.setGeoJson(Optional.of(this.filterOutPointsFromGeojson(geojson)));
        result.setInstruction(instruction);
        result.setProjectName(this.projectName);
        result.setTaskIdentifier(taskID);
        return result;
    }

    private JsonArray filterOutPointsFromGeojson(JsonArray features) {
        return this.objectStream(features).filter(feature -> feature.has(PROPERTIES) && !feature.get(PROPERTIES).getAsJsonObject().has("synthetic_highlight_point")).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }

    private Set<Location> getPointsFromGeojson(JsonArray features) {
        return this.objectStream(features).filter(feature -> !feature.has(PROPERTIES)).map(feature -> feature.get(GEOMETRY).getAsJsonObject().get(COORDINATES).getAsJsonArray()).map(longlatArray -> new Location(Latitude.degrees((double)longlatArray.get(1).getAsDouble()), Longitude.degrees((double)longlatArray.get(0).getAsDouble()))).collect(Collectors.toSet());
    }

    private Stream<JsonObject> objectStream(JsonArray features) {
        return StreamSupport.stream(features.spliterator(), false).map(JsonElement::getAsJsonObject);
    }
}

