/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.ChallengeDifficulty;
import org.openstreetmap.atlas.checks.maproulette.data.ChallengePriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChallengeDeserializer
implements JsonDeserializer<Challenge> {
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_BLURB = "blurb";
    public static final String KEY_INSTRUCTION = "instruction";
    public static final String KEY_DIFFICULTY = "difficulty";
    private static final Logger logger = LoggerFactory.getLogger(ChallengeDeserializer.class);

    public Challenge deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ChallengePriority priority;
        ChallengeDifficulty difficulty;
        JsonObject challengeObject = json.getAsJsonObject();
        try {
            difficulty = ChallengeDifficulty.valueOf(this.getStringValue(challengeObject, KEY_DIFFICULTY, ""));
        }
        catch (IllegalArgumentException e) {
            logger.trace("Failed to read difficulty value from Challenge JSON, defaulting to EASY");
            difficulty = ChallengeDifficulty.EASY;
        }
        try {
            priority = ChallengePriority.valueOf(this.getStringValue(challengeObject, "defaultPriority", String.valueOf(-1)));
        }
        catch (IllegalArgumentException e) {
            logger.trace("Failed to read priority value from Challenge JSON, defaulting to LOW");
            priority = ChallengePriority.LOW;
        }
        return new Challenge(this.getStringValue(challengeObject, "name", ""), this.getStringValue(challengeObject, KEY_DESCRIPTION, ""), this.getStringValue(challengeObject, KEY_BLURB, ""), this.getStringValue(challengeObject, KEY_INSTRUCTION, ""), difficulty, priority, this.getValue(challengeObject, "highPriorityRule", null), this.getValue(challengeObject, "mediumPriorityRule", null), this.getValue(challengeObject, "lowPriorityRule", null), this.getStringValue(challengeObject, "tags", ""));
    }

    private String getStringValue(JsonObject object, String key, String defaultValue) {
        if (object.has(key)) {
            return object.get(key).getAsString();
        }
        return defaultValue;
    }

    private String getValue(JsonObject object, String key, String defaultValue) {
        if (object.has(key)) {
            return object.get(key).toString();
        }
        return defaultValue;
    }
}

