/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConfiguration;
import org.openstreetmap.atlas.checks.maproulette.TaskLoader;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.Project;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.streaming.resource.http.GetResource;
import org.openstreetmap.atlas.streaming.resource.http.HttpResource;
import org.openstreetmap.atlas.streaming.resource.http.PostResource;
import org.openstreetmap.atlas.streaming.resource.http.PutResource;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouletteConnection
implements TaskLoader,
Serializable {
    private static final int DEFAULT_CONNECTION_RETRIES = 3;
    private static final int DEFAULT_CONNECTION_WAIT = 5;
    private static final String KEY_API_KEY = "apiKey";
    private static final String KEY_CHALLENGE = "challenge";
    private static final String KEY_SURVEY = "survey";
    private static final String KEY_ID = "id";
    private static final Logger logger = LoggerFactory.getLogger(MapRouletteConnection.class);
    private static final int MAXIMUM_BATCH_SIZE = 5000;
    private static final long serialVersionUID = -8227257938510897604L;
    private final MapRouletteConfiguration configuration;
    private final URIBuilder uriBuilder;

    MapRouletteConnection(MapRouletteConfiguration configuration) {
        if (configuration == null || !this.isAbleToConnectToMapRoulette(configuration)) {
            throw new IllegalArgumentException("configuration can't be null and must be able to connect to MapRouletteServers to create a connection.");
        }
        this.configuration = configuration;
        this.uriBuilder = new URIBuilder().setScheme(this.configuration.getScheme()).setHost(this.configuration.getServer()).setPort(this.configuration.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long create(String getURI, String postURI, String putURI, JsonObject data, String logSuccessMessage) throws UnsupportedEncodingException, URISyntaxException {
        PostResource createUpdate = null;
        GetResource challengeGet = new GetResource(this.uriBuilder.build().resolve(getURI));
        this.setAuth((HttpResource)challengeGet);
        try {
            int statusCode = challengeGet.getStatusCode();
            if (statusCode == 404 || statusCode == 204) {
                URIBuilder baseUrl = this.uriBuilder.setPath(postURI);
                createUpdate = new PostResource(baseUrl.build().toString());
                createUpdate.setStringBody(data.toString(), ContentType.APPLICATION_JSON);
            } else {
                long responseId = ((JsonObject)new Gson().fromJson(challengeGet.getRequestBodyAsString(), JsonObject.class)).get(KEY_ID).getAsLong();
                URIBuilder baseUrl = this.uriBuilder.setPath(String.format(putURI, responseId));
                createUpdate = new PutResource(baseUrl.build().toString());
                data.add(KEY_ID, (JsonElement)new JsonPrimitive((Number)responseId));
                ((PutResource)createUpdate).setStringBody(data.toString(), ContentType.APPLICATION_JSON);
            }
            this.setAuth((HttpResource)createUpdate);
            int createUpdateStatus = createUpdate.getStatusCode();
            switch (createUpdateStatus) {
                case 200: 
                case 201: {
                    long responseID = ((JsonObject)new Gson().fromJson(createUpdate.getRequestBodyAsString(), JsonObject.class)).get(KEY_ID).getAsLong();
                    logger.debug(logSuccessMessage, (Object)responseID);
                    long l = responseID;
                    return l;
                }
            }
            logger.debug("{} - {}", (Object)createUpdate.getStatusCode(), (Object)createUpdate.getRequestBodyAsString());
            long l = -1L;
            return l;
        }
        finally {
            challengeGet.close();
            if (createUpdate != null) {
                createUpdate.close();
            }
        }
    }

    @Override
    public long createChallenge(Project project, Challenge challenge) throws UnsupportedEncodingException, URISyntaxException {
        JsonObject challengeJson = challenge.toJson(challenge.getName());
        String type = challengeJson.has("answers") ? KEY_SURVEY : KEY_CHALLENGE;
        String encodedChallengeQuery = URLEncoder.encode(challenge.getName(), StandardCharsets.UTF_8).replace("+", "%20");
        return this.create(String.format("/api/v2/project/%d/challenge/%s", project.getId(), encodedChallengeQuery), String.format("/api/v2/%s", type), String.format("/api/v2/%s/", type) + "%s", challengeJson, String.format("Created/Updated Challenge with ID {} and name %s", challenge.getName()));
    }

    @Override
    public long createProject(Project project) throws UnsupportedEncodingException, URISyntaxException {
        return this.create(String.format("/api/v2/projectByName/%s", project.getName()), "/api/v2/project", "/api/v2/project/%s", project.toJson(), String.format("Created/Updated Project with ID {} and name %s", project.getName()));
    }

    @Override
    public String getConnectionInfo() {
        return this.configuration.toString();
    }

    public HttpResource setAuth(HttpResource resource) {
        resource.setHeader(KEY_API_KEY, this.configuration.getApiKey());
        return resource;
    }

    @Override
    public boolean uploadBatchTasks(long challengeId, Set<Task> data) throws UnsupportedEncodingException, URISyntaxException {
        int endIndex;
        ArrayList<Task> uniqueTasks = new ArrayList<Task>(data.size());
        uniqueTasks.addAll(data);
        boolean succeeded = true;
        int startIndex = 0;
        do {
            endIndex = Math.min(startIndex + 5000, uniqueTasks.size());
            List<Task> uploadList = uniqueTasks.subList(startIndex, endIndex);
            succeeded &= this.internalUploadBatchTasks(challengeId, uploadList);
        } while (endIndex != uniqueTasks.size() - 1 && (startIndex += 5000) < uniqueTasks.size());
        return succeeded;
    }

    @Override
    public boolean uploadTask(long challengeId, Task task) throws UnsupportedEncodingException, URISyntaxException {
        String challengeName = task.getChallengeName();
        String taskIdentifier = task.getTaskIdentifier();
        logger.debug("Uploading task {} for challenge {}", (Object)taskIdentifier, (Object)challengeName);
        return this.uploadTask(challengeId, Collections.singletonList(task), true);
    }

    private boolean internalUploadBatchTasks(long parentChallengeId, List<Task> data) throws UnsupportedEncodingException, URISyntaxException {
        if (data.isEmpty()) {
            return false;
        }
        logger.debug("Uploading batch of {} tasks for project/challenge {}/{}", new Object[]{data.size(), data.get(0).getProjectName(), data.get(0).getChallengeName()});
        return this.uploadTask(parentChallengeId, data, true);
    }

    private boolean isAbleToConnectToMapRoulette(MapRouletteConfiguration configuration) {
        return (Boolean)new Retry(3, Duration.seconds((double)5.0)).run(() -> {
            String serverConnection = String.format("%s://%s:%s", configuration.getScheme(), configuration.getServer(), configuration.getPort());
            GetResource homepage = new GetResource(serverConnection);
            int statusCode = homepage.getStatusCode();
            if (statusCode != 200) {
                logger.debug("Failed to connect to Map Roulette server [{}]. StatusCode: {}", (Object)serverConnection, (Object)statusCode);
                return false;
            }
            return true;
        });
    }

    private boolean uploadTask(long parentChallengeId, List<Task> tasks, boolean post) throws UnsupportedEncodingException, URISyntaxException {
        PostResource taskCreateUpdate;
        if (tasks.isEmpty()) {
            logger.debug("No tasks supplied in list to upload");
            return false;
        }
        boolean uploaded = false;
        JsonArray taskArray = new JsonArray();
        tasks.forEach(element -> taskArray.add((JsonElement)element.generateTask(parentChallengeId)));
        URIBuilder builder = this.uriBuilder.setPath("/api/v2/tasks");
        if (post) {
            taskCreateUpdate = new PostResource(builder.build().toString());
            taskCreateUpdate.setStringBody(taskArray.toString(), ContentType.APPLICATION_JSON);
        } else {
            taskCreateUpdate = new PutResource(builder.build().toString());
            ((PutResource)taskCreateUpdate).setStringBody(taskArray.toString(), ContentType.APPLICATION_JSON);
        }
        this.setAuth((HttpResource)taskCreateUpdate);
        int createStatus = taskCreateUpdate.getStatusCode();
        switch (createStatus) {
            case 201: {
                logger.debug("Created {} task(s) for challenge {}", (Object)tasks.size(), (Object)tasks.get(0).getChallengeName());
                uploaded = true;
                break;
            }
            case 200: {
                logger.debug("Updated {} task(s) for challenge {}", (Object)tasks.size(), (Object)tasks.get(0).getChallengeName());
                uploaded = true;
                break;
            }
            default: {
                logger.debug("{} - {}", (Object)taskCreateUpdate.getStatusCode(), (Object)taskCreateUpdate.getRequestBodyAsString());
            }
        }
        return uploaded;
    }
}

