/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.geojson.GeoJsonUtils;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlaggedRelation
extends FlaggedObject {
    private static final long serialVersionUID = 81887932468503688L;
    private static final RelationOrAreaToMultiPolygonConverter MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private static final Logger logger = LoggerFactory.getLogger(FlaggedRelation.class);
    private final String country;
    private final Map<String, String> properties;
    private final Relation relation;
    private final MultiPolygon multipolygonGeometry;

    public FlaggedRelation(Relation relation) {
        this.relation = relation;
        this.properties = this.initProperties(relation);
        this.country = this.initCountry((AtlasObject)relation);
        this.multipolygonGeometry = this.relationGeometry(relation);
    }

    public FlaggedRelation(Relation relation, MultiPolygon geoJsonGeometry) {
        this.relation = relation;
        this.properties = this.initProperties(relation);
        this.country = this.initCountry((AtlasObject)relation);
        this.multipolygonGeometry = geoJsonGeometry;
    }

    @Override
    public JsonObject asGeoJsonFeature(String flagIdentifier) {
        JsonObject featureProperties = this.relation.getGeoJsonProperties();
        JsonElement osmIdentifier = featureProperties.get("osmIdentifier");
        JsonElement identifier = featureProperties.get("identifier");
        featureProperties.remove("osmIdentifier");
        featureProperties.remove("identifier");
        featureProperties.addProperty("osmIdentifier", osmIdentifier.toString());
        featureProperties.addProperty("identifier", identifier.toString());
        featureProperties.addProperty("flag:id", flagIdentifier);
        featureProperties.addProperty("flag:type", FlaggedRelation.class.getSimpleName());
        return GeoJsonUtils.feature((JsonObject)this.multipolygonGeometry.asGeoJsonGeometry(), (JsonObject)featureProperties);
    }

    public Rectangle bounds() {
        return this.relation.bounds();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public FlaggedObject getAsCompleteFlaggedObject() {
        return new FlaggedRelation((Relation)CompleteRelation.from((Relation)this.relation), this.multipolygonGeometry);
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public Iterable<Location> getGeometry() {
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isMultipolygonRelation() {
        return Validators.isOfType((Taggable)this.relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON});
    }

    public RelationMemberList members() {
        return this.relation.members();
    }

    @Override
    protected Optional<AtlasObject> getObject() {
        return Optional.of(this.relation);
    }

    private String initCountry(AtlasObject object) {
        Map tags = object.getTags();
        if (tags.containsKey("iso_country_code")) {
            return (String)tags.get("iso_country_code");
        }
        return "N/A";
    }

    private Map<String, String> initProperties(Relation relation) {
        Map tags = relation.getTags();
        tags.put("identifier", "" + relation.getIdentifier());
        tags.put("osmIdentifier", "" + relation.getOsmIdentifier());
        tags.put("itemType", "Relation");
        return tags;
    }

    private MultiPolygon relationGeometry(Relation relation) {
        if (relation.isMultiPolygon()) {
            try {
                return MULTI_POLYGON_CONVERTER.convert((AtlasEntity)relation);
            }
            catch (CoreException exception) {
                String message = String.format("%s - %s", ((Object)((Object)exception)).getClass().getSimpleName(), exception.getMessage());
                logger.error("Unable to recreate multipolygon for relation {}. {}", (Object)relation.getIdentifier(), (Object)message);
                return MultiPolygon.forOuters((Polygon[])new Polygon[]{relation.bounds()});
            }
        }
        return MultiPolygon.forOuters((Polygon[])new Polygon[]{relation.bounds()});
    }
}

