/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.distributed;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;

public class GeoJsonPathFilter
implements PathFilter {
    private static final String UNCOMPRESSED_FILE_EXTENSION = FileSuffix.GEO_JSON.toString();
    private static final String COMPRESSED_FILE_EXTENSION = UNCOMPRESSED_FILE_EXTENSION + FileSuffix.GZIP.toString();
    private final String extension;

    public GeoJsonPathFilter() {
        this(true);
    }

    public GeoJsonPathFilter(boolean compressed) {
        this.extension = compressed ? COMPRESSED_FILE_EXTENSION : UNCOMPRESSED_FILE_EXTENSION;
    }

    public boolean accept(Path path) {
        return path.getName().endsWith(this.extension);
    }

    public String getExtension() {
        return this.extension;
    }
}

