/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.event;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationListenerMethodAdapter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class ApplicationListenerMethodTransactionalAdapter
extends ApplicationListenerMethodAdapter {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final TransactionalEventListener annotation;

    public ApplicationListenerMethodTransactionalAdapter(String beanName, Class<?> targetClass, Method method) {
        super(beanName, targetClass, method);
        this.annotation = ApplicationListenerMethodTransactionalAdapter.findAnnotation(method);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronization transactionSynchronization = this.createTransactionSynchronization(event);
            TransactionSynchronizationManager.registerSynchronization(transactionSynchronization);
        } else if (this.annotation.fallbackExecution()) {
            if (this.annotation.phase() == TransactionPhase.AFTER_ROLLBACK) {
                this.logger.warn("Processing '" + event + "' as a fallback execution on AFTER_ROLLBACK phase.");
            }
            this.processEvent(event);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("No transaction is running, skipping '" + event + "' for '" + (Object)((Object)this) + "'");
        }
    }

    private TransactionSynchronization createTransactionSynchronization(ApplicationEvent event) {
        return new TransactionSynchronizationEventAdapter(this, event, this.annotation.phase());
    }

    static TransactionalEventListener findAnnotation(Method method) {
        TransactionalEventListener annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, TransactionalEventListener.class);
        if (annotation == null) {
            throw new IllegalStateException("No TransactionalEventListener annotation found on '" + method + "'");
        }
        return annotation;
    }

    private static class TransactionSynchronizationEventAdapter
    extends TransactionSynchronizationAdapter {
        private final ApplicationListenerMethodAdapter listener;
        private final ApplicationEvent event;
        private final TransactionPhase phase;

        public TransactionSynchronizationEventAdapter(ApplicationListenerMethodAdapter listener, ApplicationEvent event, TransactionPhase phase) {
            this.listener = listener;
            this.event = event;
            this.phase = phase;
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            if (this.phase == TransactionPhase.BEFORE_COMMIT) {
                this.processEvent();
            }
        }

        @Override
        public void afterCompletion(int status) {
            if (this.phase == TransactionPhase.AFTER_COMPLETION) {
                this.processEvent();
            } else if (this.phase == TransactionPhase.AFTER_COMMIT && status == 0) {
                this.processEvent();
            } else if (this.phase == TransactionPhase.AFTER_ROLLBACK && status == 1) {
                this.processEvent();
            }
        }

        @Override
        public int getOrder() {
            return this.listener.getOrder();
        }

        protected void processEvent() {
            this.listener.processEvent(this.event);
        }
    }
}

