/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.lang.UsesJava7;
import org.springframework.util.ClassUtils;

public abstract class JdbcUtils {
    public static final int TYPE_UNKNOWN = Integer.MIN_VALUE;
    private static final boolean getObjectWithTypeAvailable = ClassUtils.hasMethod(ResultSet.class, "getObject", Integer.TYPE, Class.class);
    private static final Log logger = LogFactory.getLog(JdbcUtils.class);

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                logger.debug("Could not close JDBC Connection", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JDBC Connection", ex);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                logger.trace("Could not close JDBC Statement", ex);
            }
            catch (Throwable ex) {
                logger.trace("Unexpected exception on closing JDBC Statement", ex);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                logger.trace("Could not close JDBC ResultSet", ex);
            }
            catch (Throwable ex) {
                logger.trace("Unexpected exception on closing JDBC ResultSet", ex);
            }
        }
    }

    @UsesJava7
    public static Object getResultSetValue(ResultSet rs, int index, Class<?> requiredType) throws SQLException {
        Comparable<Boolean> value;
        if (requiredType == null) {
            return JdbcUtils.getResultSetValue(rs, index);
        }
        if (String.class == requiredType) {
            return rs.getString(index);
        }
        if (Boolean.TYPE == requiredType || Boolean.class == requiredType) {
            value = rs.getBoolean(index);
        } else if (Byte.TYPE == requiredType || Byte.class == requiredType) {
            value = rs.getByte(index);
        } else if (Short.TYPE == requiredType || Short.class == requiredType) {
            value = rs.getShort(index);
        } else if (Integer.TYPE == requiredType || Integer.class == requiredType) {
            value = rs.getInt(index);
        } else if (Long.TYPE == requiredType || Long.class == requiredType) {
            value = rs.getLong(index);
        } else if (Float.TYPE == requiredType || Float.class == requiredType) {
            value = Float.valueOf(rs.getFloat(index));
        } else if (Double.TYPE == requiredType || Double.class == requiredType || Number.class == requiredType) {
            value = rs.getDouble(index);
        } else {
            if (BigDecimal.class == requiredType) {
                return rs.getBigDecimal(index);
            }
            if (Date.class == requiredType) {
                return rs.getDate(index);
            }
            if (Time.class == requiredType) {
                return rs.getTime(index);
            }
            if (Timestamp.class == requiredType || java.util.Date.class == requiredType) {
                return rs.getTimestamp(index);
            }
            if (byte[].class == requiredType) {
                return rs.getBytes(index);
            }
            if (Blob.class == requiredType) {
                return rs.getBlob(index);
            }
            if (Clob.class == requiredType) {
                return rs.getClob(index);
            }
            if (getObjectWithTypeAvailable) {
                try {
                    return rs.getObject(index, requiredType);
                }
                catch (AbstractMethodError err) {
                    logger.debug("JDBC driver does not implement JDBC 4.1 'getObject(int, Class)' method", err);
                }
                catch (SQLFeatureNotSupportedException ex) {
                    logger.debug("JDBC driver does not support JDBC 4.1 'getObject(int, Class)' method", ex);
                }
                catch (SQLException ex) {
                    logger.debug("JDBC driver has limited support for JDBC 4.1 'getObject(int, Class)' method", ex);
                }
            }
            return JdbcUtils.getResultSetValue(rs, index);
        }
        return rs.wasNull() ? null : value;
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            obj = blob.getBytes(1L, (int)blob.length());
        } else if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            obj = clob.getSubString(1L, (int)clob.length());
        } else if ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className)) {
            obj = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, DatabaseMetaDataCallback action) throws MetaDataAccessException {
        Connection con = null;
        try {
            con = DataSourceUtils.getConnection(dataSource);
            if (con == null) {
                throw new MetaDataAccessException("Connection returned by DataSource [" + dataSource + "] was null");
            }
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData == null) {
                throw new MetaDataAccessException("DatabaseMetaData returned by Connection [" + con + "] was null");
            }
            Object object = action.processMetaData(metaData);
            return object;
        }
        catch (CannotGetJdbcConnectionException ex) {
            throw new MetaDataAccessException("Could not get Connection for extracting meta data", ex);
        }
        catch (SQLException ex) {
            throw new MetaDataAccessException("Error while extracting DatabaseMetaData", ex);
        }
        catch (AbstractMethodError err) {
            throw new MetaDataAccessException("JDBC DatabaseMetaData method not implemented by JDBC driver - upgrade your driver", err);
        }
        finally {
            DataSourceUtils.releaseConnection(con, dataSource);
        }
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, final String metaDataMethodName) throws MetaDataAccessException {
        return JdbcUtils.extractDatabaseMetaData(dataSource, new DatabaseMetaDataCallback(){

            @Override
            public Object processMetaData(DatabaseMetaData dbmd) throws SQLException, MetaDataAccessException {
                try {
                    Method method = DatabaseMetaData.class.getMethod(metaDataMethodName, null);
                    return method.invoke((Object)dbmd, (Object[])null);
                }
                catch (NoSuchMethodException ex) {
                    throw new MetaDataAccessException("No method named '" + metaDataMethodName + "' found on DatabaseMetaData instance [" + dbmd + "]", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new MetaDataAccessException("Could not access DatabaseMetaData method '" + metaDataMethodName + "'", ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof SQLException) {
                        throw (SQLException)ex.getTargetException();
                    }
                    throw new MetaDataAccessException("Invocation of DatabaseMetaData method '" + metaDataMethodName + "' failed", ex);
                }
            }
        });
    }

    public static boolean supportsBatchUpdates(Connection con) {
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            if (dbmd != null) {
                if (dbmd.supportsBatchUpdates()) {
                    logger.debug("JDBC driver supports batch updates");
                    return true;
                }
                logger.debug("JDBC driver does not support batch updates");
            }
        }
        catch (SQLException ex) {
            logger.debug("JDBC driver 'supportsBatchUpdates' method threw exception", ex);
        }
        return false;
    }

    public static String commonDatabaseName(String source) {
        String name = source;
        if (source != null && source.startsWith("DB2")) {
            name = "DB2";
        } else if ("Sybase SQL Server".equals(source) || "Adaptive Server Enterprise".equals(source) || "ASE".equals(source) || "sql server".equalsIgnoreCase(source)) {
            name = "Sybase";
        }
        return name;
    }

    public static boolean isNumeric(int sqlType) {
        return -7 == sqlType || -5 == sqlType || 3 == sqlType || 8 == sqlType || 6 == sqlType || 4 == sqlType || 2 == sqlType || 7 == sqlType || 5 == sqlType || -6 == sqlType;
    }

    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    public static String convertUnderscoreNameToPropertyName(String name) {
        StringBuilder result = new StringBuilder();
        boolean nextIsUpper = false;
        if (name != null && name.length() > 0) {
            if (name.length() > 1 && name.substring(1, 2).equals("_")) {
                result.append(name.substring(0, 1).toUpperCase());
            } else {
                result.append(name.substring(0, 1).toLowerCase());
            }
            for (int i = 1; i < name.length(); ++i) {
                String s2 = name.substring(i, i + 1);
                if (s2.equals("_")) {
                    nextIsUpper = true;
                    continue;
                }
                if (nextIsUpper) {
                    result.append(s2.toUpperCase());
                    nextIsUpper = false;
                    continue;
                }
                result.append(s2.toLowerCase());
            }
        }
        return result.toString();
    }
}

