/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.util.Vector;

public class PGtokenizer {
    protected Vector tokens;

    public PGtokenizer(String string, char delim) {
        this.tokenize(string, delim);
    }

    public int tokenize(String string, char delim) {
        this.tokens = new Vector();
        int nest = 0;
        int s2 = 0;
        for (int p = 0; p < string.length(); ++p) {
            char c = string.charAt(p);
            if (c == '(' || c == '[' || c == '<') {
                ++nest;
            }
            if (c == ')' || c == ']' || c == '>') {
                --nest;
            }
            if (nest != 0 || c != delim) continue;
            this.tokens.addElement(string.substring(s2, p));
            s2 = p + 1;
        }
        if (s2 < string.length()) {
            this.tokens.addElement(string.substring(s2));
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n) {
        return (String)this.tokens.elementAt(n);
    }

    public PGtokenizer tokenizeToken(int n, char delim) {
        return new PGtokenizer(this.getToken(n), delim);
    }

    public static String remove(String s2, String l, String t) {
        if (s2.startsWith(l)) {
            s2 = s2.substring(l.length());
        }
        if (s2.endsWith(t)) {
            s2 = s2.substring(0, s2.length() - t.length());
        }
        return s2;
    }

    public void remove(String l, String t) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            this.tokens.setElementAt(PGtokenizer.remove((String)this.tokens.elementAt(i), l, t), i);
        }
    }

    public static String removePara(String s2) {
        return PGtokenizer.remove(s2, "(", ")");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public static String removeBox(String s2) {
        return PGtokenizer.remove(s2, "[", "]");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public static String removeAngle(String s2) {
        return PGtokenizer.remove(s2, "<", ">");
    }

    public void removeAngle() {
        this.remove("<", ">");
    }
}

