/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.PGNotification;
import org.postgresql.PGProperty;
import org.postgresql.core.BaseQueryKey;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.CachedQueryCreateAction;
import org.postgresql.core.CallableQueryKey;
import org.postgresql.core.Encoding;
import org.postgresql.core.PGStream;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.QueryWithReturningColumnsKey;
import org.postgresql.core.TransactionState;
import org.postgresql.core.Utils;
import org.postgresql.jdbc.AutoSave;
import org.postgresql.jdbc.PreferQueryMode;
import org.postgresql.util.HostSpec;
import org.postgresql.util.LruCache;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;

public abstract class QueryExecutorBase
implements QueryExecutor {
    private static final Logger LOGGER = Logger.getLogger(QueryExecutorBase.class.getName());
    protected final PGStream pgStream;
    private final String user;
    private final String database;
    private final int cancelSignalTimeout;
    private int cancelPid;
    private int cancelKey;
    private boolean closed = false;
    private String serverVersion;
    private int serverVersionNum = 0;
    private TransactionState transactionState;
    private final boolean reWriteBatchedInserts;
    private final boolean columnSanitiserDisabled;
    private final PreferQueryMode preferQueryMode;
    private AutoSave autoSave;
    private boolean flushCacheOnDeallocate = true;
    private boolean standardConformingStrings = false;
    private SQLWarning warnings;
    private final ArrayList<PGNotification> notifications = new ArrayList();
    private final LruCache<Object, CachedQuery> statementCache;
    private final CachedQueryCreateAction cachedQueryCreateAction;

    protected QueryExecutorBase(PGStream pgStream, String user, String database, int cancelSignalTimeout, Properties info) throws SQLException {
        this.pgStream = pgStream;
        this.user = user;
        this.database = database;
        this.cancelSignalTimeout = cancelSignalTimeout;
        this.reWriteBatchedInserts = PGProperty.REWRITE_BATCHED_INSERTS.getBoolean(info);
        this.columnSanitiserDisabled = PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        String preferMode = PGProperty.PREFER_QUERY_MODE.get(info);
        this.preferQueryMode = PreferQueryMode.of(preferMode);
        this.autoSave = AutoSave.of(PGProperty.AUTOSAVE.get(info));
        this.cachedQueryCreateAction = new CachedQueryCreateAction(this);
        this.statementCache = new LruCache<Object, CachedQuery>(Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.getInt(info)), Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getInt(info) * 1024 * 1024), false, this.cachedQueryCreateAction, new LruCache.EvictAction<CachedQuery>(){

            @Override
            public void evict(CachedQuery cachedQuery) throws SQLException {
                cachedQuery.query.close();
            }
        });
    }

    protected abstract void sendCloseMessage() throws IOException;

    public void setNetworkTimeout(int milliseconds) throws IOException {
        this.pgStream.setNetworkTimeout(milliseconds);
    }

    public int getNetworkTimeout() throws IOException {
        return this.pgStream.getNetworkTimeout();
    }

    public HostSpec getHostSpec() {
        return this.pgStream.getHostSpec();
    }

    public String getUser() {
        return this.user;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setBackendKeyData(int cancelPid, int cancelKey) {
        this.cancelPid = cancelPid;
        this.cancelKey = cancelKey;
    }

    public int getBackendPID() {
        return this.cancelPid;
    }

    public void abort() {
        try {
            this.pgStream.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            LOGGER.log(Level.FINEST, " FE=> Terminate");
            this.sendCloseMessage();
            this.pgStream.flush();
            this.pgStream.close();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINEST, "Discarding IOException on close:", ioe);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void sendQueryCancel() throws SQLException {
        if (this.cancelPid <= 0) {
            return;
        }
        PGStream cancelStream = null;
        try {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, " FE=> CancelRequest(pid={0},ckey={1})", new Object[]{this.cancelPid, this.cancelKey});
            }
            cancelStream = new PGStream(this.pgStream.getSocketFactory(), this.pgStream.getHostSpec(), this.cancelSignalTimeout);
            if (this.cancelSignalTimeout > 0) {
                cancelStream.getSocket().setSoTimeout(this.cancelSignalTimeout);
            }
            cancelStream.sendInteger4(16);
            cancelStream.sendInteger2(1234);
            cancelStream.sendInteger2(5678);
            cancelStream.sendInteger4(this.cancelPid);
            cancelStream.sendInteger4(this.cancelKey);
            cancelStream.flush();
            cancelStream.receiveEOF();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, "Ignoring exception on cancel request:", e);
        }
        finally {
            if (cancelStream != null) {
                try {
                    cancelStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void addWarning(SQLWarning newWarning) {
        if (this.warnings == null) {
            this.warnings = newWarning;
        } else {
            this.warnings.setNextWarning(newWarning);
        }
    }

    public synchronized void addNotification(PGNotification notification) {
        this.notifications.add(notification);
    }

    public synchronized PGNotification[] getNotifications() throws SQLException {
        PGNotification[] array = this.notifications.toArray(new PGNotification[0]);
        this.notifications.clear();
        return array;
    }

    public synchronized SQLWarning getWarnings() {
        SQLWarning chain = this.warnings;
        this.warnings = null;
        return chain;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int getServerVersionNum() {
        if (this.serverVersionNum != 0) {
            return this.serverVersionNum;
        }
        this.serverVersionNum = Utils.parseServerVersionStr((String)this.serverVersion);
        return this.serverVersionNum;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public void setServerVersionNum(int serverVersionNum) {
        this.serverVersionNum = serverVersionNum;
    }

    public synchronized void setTransactionState(TransactionState state) {
        this.transactionState = state;
    }

    public synchronized void setStandardConformingStrings(boolean value) {
        this.standardConformingStrings = value;
    }

    public synchronized boolean getStandardConformingStrings() {
        return this.standardConformingStrings;
    }

    public synchronized TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        this.pgStream.setEncoding(encoding);
    }

    public Encoding getEncoding() {
        return this.pgStream.getEncoding();
    }

    public boolean isReWriteBatchedInsertsEnabled() {
        return this.reWriteBatchedInserts;
    }

    public final CachedQuery borrowQuery(String sql) throws SQLException {
        return this.statementCache.borrow(sql);
    }

    public final CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.statementCache.borrow(new CallableQueryKey(sql));
    }

    public final CachedQuery borrowReturningQuery(String sql, String[] columnNames) throws SQLException {
        return this.statementCache.borrow(new QueryWithReturningColumnsKey(sql, true, true, columnNames));
    }

    public CachedQuery borrowQueryByKey(Object key) throws SQLException {
        return this.statementCache.borrow(key);
    }

    public void releaseQuery(CachedQuery cachedQuery) {
        this.statementCache.put(cachedQuery.key, cachedQuery);
    }

    public final Object createQueryKey(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) {
        Object key = columnNames == null || columnNames.length != 0 ? new QueryWithReturningColumnsKey(sql, isParameterized, escapeProcessing, columnNames) : (isParameterized ? sql : new BaseQueryKey(sql, false, escapeProcessing));
        return key;
    }

    public CachedQuery createQueryByKey(Object key) throws SQLException {
        return this.cachedQueryCreateAction.create(key);
    }

    public final CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        Object key = this.createQueryKey(sql, escapeProcessing, isParameterized, columnNames);
        return this.createQueryByKey(key);
    }

    public boolean isColumnSanitiserDisabled() {
        return this.columnSanitiserDisabled;
    }

    public PreferQueryMode getPreferQueryMode() {
        return this.preferQueryMode;
    }

    public AutoSave getAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(AutoSave autoSave) {
        this.autoSave = autoSave;
    }

    protected boolean willHealViaReparse(SQLException e) {
        if (PSQLState.INVALID_SQL_STATEMENT_NAME.getState().equals(e.getSQLState())) {
            return true;
        }
        if (!PSQLState.NOT_IMPLEMENTED.getState().equals(e.getSQLState())) {
            return false;
        }
        if (!(e instanceof PSQLException)) {
            return false;
        }
        PSQLException pe = (PSQLException)e;
        ServerErrorMessage serverErrorMessage = pe.getServerErrorMessage();
        if (serverErrorMessage == null) {
            return false;
        }
        String routine = pe.getServerErrorMessage().getRoutine();
        return "RevalidateCachedQuery".equals(routine) || "RevalidateCachedPlan".equals(routine);
    }

    public boolean willHealOnRetry(SQLException e) {
        if (this.autoSave == AutoSave.NEVER && this.getTransactionState() == TransactionState.FAILED) {
            return false;
        }
        return this.willHealViaReparse(e);
    }

    public boolean isFlushCacheOnDeallocate() {
        return this.flushCacheOnDeallocate;
    }

    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.flushCacheOnDeallocate = flushCacheOnDeallocate;
    }

    protected boolean hasNotifications() {
        return this.notifications.size() > 0;
    }
}

