/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.util.Map;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.xml.common.ElementWriter;

public class EntityWriter
extends ElementWriter {
    protected EntityWriter(String elementName, int indentionLevel) {
        super(elementName, indentionLevel);
    }

    protected void addCommonAttributes(Entity entity) {
        this.addAttribute("id", Long.toString(entity.getId()));
        this.addAttribute("version", Integer.toString(entity.getVersion()));
        this.addAttribute("timestamp", entity.getFormattedTimestamp(this.getTimestampFormat()));
        OsmUser user = entity.getUser();
        if (!user.equals(OsmUser.NONE)) {
            this.addAttribute("uid", Integer.toString(user.getId()));
            this.addAttribute("user", user.getName());
        }
        if (entity.getChangesetId() != 0L) {
            this.addAttribute("changeset", Long.toString(entity.getChangesetId()));
        }
    }

    protected void addMetatags(Entity entity) {
        for (Map.Entry<String, Object> metaTag : entity.getMetaTags().entrySet()) {
            this.addAttribute(metaTag.getKey(), metaTag.getValue().toString());
        }
    }
}

