/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.openstreetmap.osmosis.core.domain.common.SimpleTimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.util.LongAsInt;

@Deprecated
public abstract class EntityBuilder<T extends Entity>
implements Storeable {
    protected long id;
    protected int version;
    protected TimestampContainer timestampContainer;
    protected OsmUser user;
    protected int changesetId;
    protected Collection<Tag> tags = new ArrayList<Tag>();

    public EntityBuilder() {
    }

    public EntityBuilder(Entity entity) {
        this();
        this.initialize(entity);
    }

    public EntityBuilder(long id, int version, Date timestamp, OsmUser user, long changesetId) {
        this();
        this.initialize(id, version, timestamp, user, changesetId);
    }

    public EntityBuilder(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId) {
        this();
        this.initialize(id, version, timestampContainer, user, changesetId);
    }

    protected EntityBuilder<T> initialize(Entity entity) {
        this.initialize(entity.getId(), entity.getVersion(), entity.getTimestampContainer(), entity.getUser(), entity.getChangesetId());
        this.tags.addAll(entity.getTags());
        return this;
    }

    protected EntityBuilder<T> initialize(long newId, int newVersion, Date newTimestamp, OsmUser newUser, long newChangesetId) {
        this.initialize(newId, newVersion, new SimpleTimestampContainer(newTimestamp), newUser, newChangesetId);
        return this;
    }

    protected EntityBuilder<T> initialize(long newId, int newVersion, TimestampContainer newTimestampContainer, OsmUser newUser, long newChangesetId) {
        this.id = newId;
        this.timestampContainer = newTimestampContainer;
        this.user = newUser;
        this.changesetId = LongAsInt.longToInt(newChangesetId);
        this.version = newVersion;
        this.tags.clear();
        return this;
    }

    public EntityBuilder<T> setId(long newId) {
        this.id = newId;
        return this;
    }

    public long getId() {
        return this.id;
    }

    public EntityBuilder<T> setVersion(int newVersion) {
        this.version = newVersion;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public EntityBuilder<T> setTimestamp(Date timestamp) {
        this.timestampContainer = new SimpleTimestampContainer(timestamp);
        return this;
    }

    public Date getTimestamp() {
        return this.timestampContainer.getTimestamp();
    }

    public EntityBuilder<T> setTimestamp(TimestampContainer newTimestampContainer) {
        this.timestampContainer = newTimestampContainer;
        return this;
    }

    public TimestampContainer getTimestampContainer() {
        return this.timestampContainer;
    }

    public EntityBuilder<T> setUser(OsmUser newUser) {
        this.user = newUser;
        return this;
    }

    public OsmUser getUser() {
        return this.user;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public EntityBuilder<T> setChangesetId(long newChangesetId) {
        this.changesetId = LongAsInt.longToInt(newChangesetId);
        return this;
    }

    public Collection<Tag> getTags() {
        return this.tags;
    }

    public EntityBuilder<T> clearTags() {
        this.tags.clear();
        return this;
    }

    public EntityBuilder<T> setTags(Collection<Tag> newTags) {
        this.tags.clear();
        this.tags.addAll(newTags);
        return this;
    }

    public EntityBuilder<T> addTag(Tag tag) {
        this.tags.add(tag);
        return this;
    }

    public abstract T buildEntity();
}

