/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.vectortiles;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.openstreetmap.atlas.geography.atlas.geojson.LineDelimitedGeoJsonConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.vectortiles.TippecanoeCommands;
import org.openstreetmap.atlas.utilities.vectortiles.TippecanoeSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TippecanoeExporter
extends LineDelimitedGeoJsonConverter {
    private static final int EXIT_FAILURE = 1;
    private static final Logger logger = LoggerFactory.getLogger(TippecanoeExporter.class);
    private static final Command.Switch<Path> MBTILES = new Command.Switch("mbtiles", "The MBTiles file to which tippecanoe will write vector tiles.", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new TippecanoeExporter().run(args);
    }

    private TippecanoeExporter() {
        this.setJsonMutator(TippecanoeSettings.JSON_MUTATOR);
    }

    @Override
    protected int onRun(CommandMap command) {
        super.onRun(command);
        if (!TippecanoeCommands.hasValidTippecanoe()) {
            logger.error("Your system does not have a valid installation of tippecanoe installed in its path.");
            logger.error("https://github.com/mapbox/tippecanoe");
            System.exit(1);
        }
        Path mbtiles = (Path)command.get(MBTILES);
        Path geojsonDirectory = (Path)command.get(GEOJSON_DIRECTORY);
        Path geojson = geojsonDirectory.resolve("EVERYTHING.geojson");
        Boolean overwrite = (Boolean)command.get(OVERWRITE);
        TippecanoeCommands.runTippecanoe(geojson, mbtiles, overwrite);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return super.switches().with(MBTILES);
    }
}

