/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.vectortiles;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.vectortiles.TippecanoeCommands;
import org.openstreetmap.atlas.utilities.vectortiles.TippecanoeSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TippecanoeConverter
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(TippecanoeConverter.class);
    private static final Command.Switch<Path> GEOJSON_DIRECTORY = new Command.Switch("geojsonDirectory", "The directory to read line-delimited GeoJSON.", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> MBTILES = new Command.Switch("mbtiles", "The MBTiles file to which tippecanoe will write vector tiles.", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Boolean> OVERWRITE = new Command.Switch("overwrite", "Choose to automatically overwrite an MBTiles file if it exists at the given path.", Boolean::new, Command.Optionality.OPTIONAL, "false");

    public static void main(String[] args) {
        new TippecanoeConverter().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        if (!TippecanoeCommands.hasValidTippecanoe()) {
            logger.error("Your system does not have a valid installation of tippecanoe installed in its path.");
            logger.error("https://github.com/mapbox/tippecanoe");
            System.exit(1);
        }
        Path mbtiles = (Path)command.get(MBTILES);
        Path geojsonDirectory = (Path)command.get(GEOJSON_DIRECTORY);
        Path geojson = geojsonDirectory.resolve("EVERYTHING.geojson");
        Boolean overwrite = (Boolean)command.get(OVERWRITE);
        TippecanoeCommands.decompress(geojsonDirectory);
        TippecanoeCommands.concatenate(geojsonDirectory);
        TippecanoeCommands.runTippecanoe(geojson, mbtiles, overwrite, TippecanoeSettings.ARGS);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(GEOJSON_DIRECTORY, MBTILES, OVERWRITE);
    }
}

