/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.vectortiles;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.runtime.RunScript;
import org.openstreetmap.atlas.utilities.runtime.SingleLineMonitor;
import org.openstreetmap.atlas.utilities.time.Time;
import org.openstreetmap.atlas.utilities.vectortiles.TippecanoeSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TippecanoeCommands {
    private static final Logger logger = LoggerFactory.getLogger(TippecanoeCommands.class);
    private static final SingleLineMonitor MONITOR = new SingleLineMonitor(){

        @Override
        protected Optional<String> parseResult(String line) {
            return Optional.of(line);
        }
    };

    public static void concatenate(Path geojsonDirectory) {
        Time time = Time.now();
        logger.info("Concatenating GeoJSON...");
        String directory = geojsonDirectory.toString();
        String cat = String.format("find '%s' -type f -name '*.geojson' \\! -path '%s'/%s -exec cat \\{\\} + > '%s/'%s", directory, directory, "EVERYTHING.geojson", directory, "EVERYTHING.geojson");
        logger.info(cat);
        String[] bashCommandArray = new String[]{"bash", "-c", cat};
        RunScript.run(bashCommandArray);
        logger.info("Concatenated to {} in {}", (Object)"EVERYTHING.geojson", (Object)time.elapsedSince());
    }

    public static void decompress(Path geojsonDirectory) {
        Time time = Time.now();
        String directory = geojsonDirectory.toString();
        String cat = String.format("find '%s' -type f -name '*.geojson.gz' -exec gzip -dr \\{\\} +", directory);
        String[] bashCommandArray = new String[]{"bash", "-c", cat};
        try {
            RunScript.run(bashCommandArray);
            logger.info("Decompressed line-delimited GeoJSON in {}", (Object)time.elapsedSince());
        }
        catch (CoreException exception) {
            logger.warn("Not finding any .geojson.gz to decompress. Continuing...", (Throwable)exception);
        }
    }

    public static boolean hasValidTippecanoe() {
        String[] commandArray = new String[]{"tippecanoe", "--version"};
        try {
            RunScript.run(commandArray, Collections.singletonList(MONITOR));
        }
        catch (CoreException exception) {
            logger.warn("Note that tippecanoe exited with 1 when checking the version; this is known and does not cause a problem for us.", (Throwable)exception);
            return TippecanoeCommands.checkVersion();
        }
        return TippecanoeCommands.checkVersion();
    }

    public static void runTippecanoe(Path geojson, Path mbtiles, boolean overwrite) {
        TippecanoeCommands.runTippecanoe(geojson, mbtiles, overwrite, TippecanoeSettings.ARGS);
    }

    public static void runTippecanoe(Path geojson, Path mbtiles, boolean overwrite, String[] args) {
        Time time = Time.now();
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("tippecanoe");
        commandList.add("-o");
        commandList.add(mbtiles.toString());
        commandList.addAll(Arrays.asList(args));
        if (overwrite) {
            commandList.add("--force");
        }
        commandList.add(geojson.toString());
        Object[] commandArray = commandList.toArray(new String[0]);
        logger.info("Running tippecanoe...");
        logger.info(StringUtils.join(commandArray, " "));
        RunScript.run((String[])commandArray);
        logger.info("tippecanoe has successfully generated vector tiles in {}", (Object)mbtiles);
        logger.info("tippecanoe took {}", (Object)time.elapsedSince());
    }

    private static boolean checkVersion() {
        String outputString;
        String[] versionArray;
        Optional<String> result = MONITOR.getResult();
        if (result.isPresent() && (versionArray = (outputString = result.get()).split("\n")[0].split("tippecanoe v")).length == 2) {
            String versionString = versionArray[1];
            DefaultArtifactVersion version = new DefaultArtifactVersion(versionString);
            if (TippecanoeSettings.MIN_VERSION.compareTo(version) <= 0) {
                return true;
            }
            logger.error("Your version of tippecanoe is too old! The minimum version is {}", (Object)TippecanoeSettings.MIN_VERSION);
        }
        return false;
    }

    private TippecanoeCommands() {
    }
}

