/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.unicode;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.unicode.Classification;
import org.openstreetmap.atlas.utilities.unicode.Classifier;

public abstract class AbstractClassifier
implements Classifier {
    private final RangeMap<Integer, Classification.CodeBlock> classificationTable = TreeRangeMap.create();
    private final BitSet ignoreTable = new BitSet();

    protected AbstractClassifier() {
    }

    @Override
    public Classification classify(CharSequence sequence) {
        if (sequence == null) {
            throw new CoreException("value can't be null");
        }
        BitSet classifications = new BitSet();
        ArrayList<Character> unknowns = new ArrayList<Character>();
        sequence.chars().filter(this.createIgnorePredicate()).forEach(character -> {
            Classification.CodeBlock classification = this.classificationTable.get(character);
            if (classification == null) {
                unknowns.add(Character.valueOf((char)character));
            } else {
                classifications.set(classification.ordinal());
            }
        });
        return new DefaultClassification(classifications, unknowns);
    }

    @Override
    public List<Optional<Classification.CodeBlock>> transform(CharSequence sequence) {
        return sequence.chars().mapToObj(character -> Optional.ofNullable(this.classificationTable.get(character))).collect(Collectors.toList());
    }

    protected final void add(String description, int start, int end, Classification.CodeBlock classification) {
        this.add(description, Range.closed(start, end), classification);
    }

    protected final void add(String description, Range<Integer> range, Classification.CodeBlock classification) {
        this.classificationTable.put(range, classification);
    }

    protected IntPredicate createIgnorePredicate() {
        return item -> !this.ignoreTable.get(item);
    }

    protected final void ignore(String description, int index) {
        this.ignoreTable.set(index);
    }

    protected final void ignore(String description, int start, int end) {
        this.ignoreTable.set(start, end + 1);
    }

    protected abstract AbstractClassifier initialize();

    private static final class DefaultClassification
    implements Classification {
        private final BitSet classifications;
        private final Collection<Character> unknownCharacters;

        DefaultClassification(BitSet classifications, Collection<Character> unknownCharacters) {
            this.classifications = classifications;
            this.unknownCharacters = Collections.unmodifiableCollection(unknownCharacters);
        }

        @Override
        public int getClassificationCount() {
            return this.classifications.cardinality();
        }

        @Override
        public Iterable<Character> getUnclassifiedCharacters() {
            return this.unknownCharacters;
        }

        @Override
        public boolean has(Classification.CodeBlock classification) {
            return this.classifications.get(classification.ordinal());
        }

        @Override
        public Iterator<Classification.CodeBlock> iterator() {
            return new AbstractIterator<Classification.CodeBlock>(){
                private int currentIndex;
                {
                    this.currentIndex = classifications.nextSetBit(0);
                }

                @Override
                protected Classification.CodeBlock computeNext() {
                    if (this.currentIndex < 0 || this.currentIndex == Integer.MAX_VALUE) {
                        return (Classification.CodeBlock)((Object)this.endOfData());
                    }
                    Classification.CodeBlock returnValue = Classification.CodeBlock.values()[this.currentIndex];
                    this.currentIndex = classifications.nextSetBit(this.currentIndex + 1);
                    return returnValue;
                }
            };
        }
    }
}

