/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.timezone;

import java.util.TimeZone;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.utilities.scalars.Surface;

public class TimeZoneBoundary
implements Located {
    private final TimeZone timeZone;
    private final Polygon polygon;

    public TimeZoneBoundary(TimeZone timeZone, Polygon polygon) {
        this.timeZone = timeZone;
        this.polygon = polygon;
    }

    public Surface area() {
        return this.polygon.bounds().surface();
    }

    @Override
    public Rectangle bounds() {
        return this.polygon.bounds();
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return this.timeZone.getID() + " " + this.bounds();
    }
}

