/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class CustomNamesThreadPoolFactory
implements ThreadFactory {
    private final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    protected CustomNamesThreadPoolFactory(String poolName) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = poolName + "(" + this.poolNumber.getAndIncrement() + ")-thread-";
    }

    @Override
    public Thread newThread(Runnable runme) {
        String newThreadName = this.namePrefix + this.threadNumber.getAndIncrement();
        return new Thread(this.group, runme, newThreadName, 0L);
    }
}

