/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.scalars;

import java.io.Serializable;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class Angle
implements Serializable {
    public static final int DM7_PER_DEGREE = 10000000;
    public static final int MINIMUM_DM7 = -1800000000;
    public static final int MAXIMUM_DM7 = 1800000000;
    public static final int DM7_PER_RADIAN = 572957795;
    public static final double DM7_PER_RADIAN_DOUBLE = Double.valueOf(1.8E9) / Math.PI;
    public static final long REVOLUTION_DM7 = 3600000000L;
    public static final Angle MINIMUM = Angle.dm7(-1800000000L);
    public static final Angle NONE = Angle.dm7(0L);
    public static final Angle MAXIMUM = Angle.dm7(1799999999L);
    public static final int DM7_PER_MICRODEGREE = 10;
    public static final int DM7_PRINT_THRESHOLD = 10000;
    private static final long serialVersionUID = -5120437813288084229L;
    private final int dm7;

    public static Angle degrees(double degrees2) {
        return Angle.dm7(Math.round(degrees2 * 1.0E7));
    }

    public static Angle dm7(long dm7) {
        long rollingMicroDegrees = dm7 % 3600000000L;
        if (rollingMicroDegrees < -1800000000L) {
            rollingMicroDegrees += 3600000000L;
        }
        if (rollingMicroDegrees >= 1800000000L) {
            rollingMicroDegrees -= 3600000000L;
        }
        return new Angle((int)rollingMicroDegrees);
    }

    public static Angle radians(double radians2) {
        return Angle.dm7(Math.round(radians2 * 5.72957795E8));
    }

    protected Angle(int dm7) {
        this.dm7 = this.assertDm7(dm7);
    }

    public final Angle add(Angle that) {
        return Angle.dm7(this.getDm7() + that.getDm7());
    }

    public double asDegrees() {
        return (double)this.asDm7() / 1.0E7;
    }

    public long asDm7() {
        return this.dm7;
    }

    public Angle asPositiveAngle() {
        if (this.dm7 == -1800000000) {
            return MAXIMUM;
        }
        return Angle.dm7(Math.abs(this.dm7));
    }

    public double asPositiveRadians() {
        return this.asRadians() < 0.0 ? this.asRadians() + Math.PI * 2 : this.asRadians();
    }

    public double asRadians() {
        return (double)this.asDm7() / DM7_PER_RADIAN_DOUBLE;
    }

    public final Angle difference(Angle that) {
        return this.subtract(that).asPositiveAngle();
    }

    public boolean equals(Object other) {
        if (other instanceof Angle) {
            Angle that = (Angle)other;
            return this.getDm7() == that.getDm7();
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.dm7);
    }

    public final boolean isGreaterThan(Angle other) {
        if (other.getClass() == this.getClass()) {
            return this.asDm7() > other.asDm7();
        }
        return this.getDm7() > other.getDm7();
    }

    public final boolean isGreaterThanOrEqualTo(Angle other) {
        if (other.getClass() == this.getClass()) {
            return this.asDm7() >= other.asDm7();
        }
        return this.getDm7() >= other.getDm7();
    }

    public final boolean isLessThan(Angle other) {
        if (other.getClass() == this.getClass()) {
            return this.asDm7() < other.asDm7();
        }
        return this.getDm7() < other.getDm7();
    }

    public final boolean isLessThanOrEqualTo(Angle other) {
        if (other.getClass() == this.getClass()) {
            return this.asDm7() <= other.asDm7();
        }
        return this.getDm7() <= other.getDm7();
    }

    public Distance onEarth() {
        return Distance.AVERAGE_EARTH_RADIUS.scaleBy(this.asPositiveRadians());
    }

    public final Angle subtract(Angle that) {
        return Angle.dm7(this.getDm7() - that.getDm7());
    }

    public String toString() {
        if (Math.abs(this.getDm7()) >= 10000L) {
            return this.asDegrees() + " degrees";
        }
        return this.asDm7() + " tenths of microdegrees";
    }

    protected int assertDm7(int dm7) {
        if (dm7 < -1800000000 || dm7 >= 1800000000) {
            throw new IllegalArgumentException("Angle dm7 value " + dm7 + " is invalid.");
        }
        return dm7;
    }

    private long getDm7() {
        return this.dm7;
    }
}

