/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.util.Iterator;
import java.util.Optional;
import org.openstreetmap.atlas.utilities.runtime.RunScriptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleLineMonitor
extends RunScriptMonitor {
    private static final Logger logger = LoggerFactory.getLogger(SingleLineMonitor.class);
    private Optional<String> result = Optional.empty();

    public Optional<String> getResult() {
        return this.result;
    }

    protected abstract Optional<String> parseResult(String var1);

    @Override
    protected void parseStandardError(Iterable<String> lines) {
        this.parseStandardStream(lines);
    }

    @Override
    protected void parseStandardOutput(Iterable<String> lines) {
        this.parseStandardStream(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void parseStandardStream(Iterable<String> lines) {
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            Optional<String> resultOption;
            String line = iterator.next();
            if (this.result.isPresent() || !(resultOption = this.parseResult(line)).isPresent()) continue;
            Class<SingleLineMonitor> clazz = SingleLineMonitor.class;
            // MONITORENTER : org.openstreetmap.atlas.utilities.runtime.SingleLineMonitor.class
            if (!this.result.isPresent()) {
                this.result = resultOption;
                logger.trace("Found result: {}", (Object)resultOption.get());
            }
            // MONITOREXIT : clazz
        }
    }
}

