/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.SplittableInputStream;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.utilities.runtime.RunScriptMonitor;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RunScript {
    private static final Logger logger = LoggerFactory.getLogger(RunScript.class);

    public static void run(String command) {
        RunScript.run(command.split("\\s+"));
    }

    public static void run(String command, List<RunScriptMonitor> monitors) {
        RunScript.run(command.split("\\s+"), monitors);
    }

    public static void run(String[] commandArray) {
        RunScript.run(commandArray, new ArrayList<RunScriptMonitor>());
    }

    public static void run(String[] commandArray, List<RunScriptMonitor> monitors) {
        int returnValue = 0;
        try {
            String[] env = System.getenv().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList()).toArray(new String[0]);
            Process process = Runtime.getRuntime().exec(commandArray, env);
            RunScriptMonitor.PrinterMonitor printer = new RunScriptMonitor.PrinterMonitor(logger);
            SplittableInputStream standardOut = null;
            SplittableInputStream standardErr = null;
            if (monitors != null && !monitors.isEmpty()) {
                standardOut = new SplittableInputStream(process.getInputStream());
                standardErr = new SplittableInputStream(process.getErrorStream());
                ArrayList<SplittableInputStream> otherStandardOuts = new ArrayList<SplittableInputStream>();
                ArrayList<SplittableInputStream> otherStandardErrs = new ArrayList<SplittableInputStream>();
                for (RunScriptMonitor monitor : monitors) {
                    otherStandardOuts.add(standardOut.split());
                    otherStandardErrs.add(standardErr.split());
                }
                printer.parse(standardOut, standardErr);
                for (int index = 0; index < monitors.size(); ++index) {
                    RunScriptMonitor monitor;
                    monitor = monitors.get(index);
                    InputStream otherStandardOut = (InputStream)otherStandardOuts.get(index);
                    InputStream otherStandardErr = (InputStream)otherStandardErrs.get(index);
                    monitor.parse(otherStandardOut, otherStandardErr);
                }
            } else {
                printer.parse(process.getInputStream(), process.getErrorStream());
            }
            returnValue = process.waitFor();
            printer.waitForCompletion(Duration.ONE_SECOND);
            if (monitors != null && !monitors.isEmpty()) {
                for (RunScriptMonitor monitor : monitors) {
                    monitor.waitForCompletion(Duration.ONE_SECOND);
                }
                Streams.close(standardOut);
                Streams.close(standardErr);
            }
        }
        catch (Exception e) {
            throw new CoreException("Could not launch script \"{}\"", commandArray, e);
        }
        if (returnValue != 0) {
            throw new CoreException("Non-Zero return value {} when running script \"{}\".", returnValue, commandArray);
        }
    }

    private RunScript() {
    }
}

