/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry {
    private static final Logger logger = LoggerFactory.getLogger(Retry.class);
    private static final Predicate<Throwable> FILTER_NONE = throwable -> false;
    private final int retries;
    private final Duration waitBeforeRetry;
    private boolean quiet = false;
    private boolean quadratic = false;

    public Retry(int retries, Duration waitBeforeRetry) {
        this.retries = Math.max(retries, 0);
        this.waitBeforeRetry = waitBeforeRetry;
    }

    public boolean isQuadratic() {
        return this.quadratic;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void run(Runnable runnable) {
        this.run(runnable, null, FILTER_NONE);
    }

    public void run(Runnable runnable, Predicate<Throwable> exceptionsWhichShouldBreakDirectly) {
        this.run(runnable, null, exceptionsWhichShouldBreakDirectly);
    }

    public void run(Runnable runnable, Runnable runBeforeRetry) {
        this.run(runnable, runBeforeRetry, FILTER_NONE);
    }

    public void run(Runnable runnable, Runnable runBeforeRetry, Predicate<Throwable> exceptionsWhichShouldBreakDirectly) {
        this.run(() -> {
            runnable.run();
            return "";
        }, runBeforeRetry, exceptionsWhichShouldBreakDirectly);
    }

    public <V> V run(Supplier<V> callable) {
        return this.run(callable, null, FILTER_NONE);
    }

    public <V> V run(Supplier<V> callable, Predicate<Throwable> exceptionsWhichShouldBreakDirectly) {
        return this.run(callable, null, exceptionsWhichShouldBreakDirectly);
    }

    public <V> V run(Supplier<V> callable, Runnable runBeforeRetry) {
        return this.run(callable, runBeforeRetry, FILTER_NONE);
    }

    public <V> V run(Supplier<V> callable, Runnable runBeforeRetry, Predicate<Throwable> exceptionsWhichShouldBreakDirectly) {
        int retry = 0;
        V result = null;
        boolean success = false;
        Throwable lastError = null;
        while (!success && retry <= this.retries) {
            try {
                if (retry > 0 && runBeforeRetry != null) {
                    runBeforeRetry.run();
                }
                result = callable.get();
                success = true;
            }
            catch (Throwable throwable) {
                if (exceptionsWhichShouldBreakDirectly.test(throwable)) {
                    throw throwable;
                }
                if (!this.quiet && logger.isErrorEnabled()) {
                    logger.error("Failed retry number {}", (Object)retry, (Object)throwable);
                }
                lastError = throwable;
                this.wait(++retry);
            }
        }
        if (success) {
            return result;
        }
        throw new CoreException("Failed execution after {} retries.", retry, lastError);
    }

    public void setQuadratic(boolean quadratic) {
        this.quadratic = quadratic;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public Retry withQuadratic(boolean quadratic) {
        this.setQuadratic(quadratic);
        return this;
    }

    public Retry withQuiet(boolean quiet) {
        this.setQuiet(quiet);
        return this;
    }

    private void wait(int retry) {
        if (retry > 1 && this.quadratic) {
            Duration quadraticWait = this.waitBeforeRetry.times(Math.pow(2.0, (double)retry - 1.0));
            if (logger.isInfoEnabled()) {
                logger.info("Wait is quadratic. Waiting {}", (Object)quadraticWait);
            }
            quadraticWait.sleep();
        } else {
            this.waitBeforeRetry.sleep();
        }
    }
}

