/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.EnhancedCollectors;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command {
    private static final Logger logger = LoggerFactory.getLogger(Command.class);
    private CommandMap command = null;
    private Map<Switch<?>, String> lastRawCommand;

    public CommandMap getCommandMap(String[] arguments) {
        if (this.command == null) {
            Map switches = this.switches().stream().collect(EnhancedCollectors.toLinkedMap(Switch::getName, Function.identity()));
            HashMap inputValues = new HashMap();
            HashMap<String, String> unknownValues = new HashMap<String, String>();
            for (int i = 0; i < arguments.length; ++i) {
                String currentSwitch = arguments[i];
                if (!currentSwitch.startsWith("-")) continue;
                try {
                    String switchString = currentSwitch.substring(1);
                    StringList switchStringParts = StringList.split(switchString, "=", 2);
                    String switchName = switchStringParts.get(0);
                    Switch foundSwitch = (Switch)switches.get(switchName);
                    if (foundSwitch instanceof Flag) {
                        logger.info("Found flag {}", (Object)switchName, (Object)Boolean.TRUE.toString());
                        inputValues.put(foundSwitch, Boolean.TRUE.toString());
                        continue;
                    }
                    if (switchStringParts.size() != 2) {
                        logger.warn("Switch [{}] contains empty string", (Object)switchString);
                        continue;
                    }
                    String switchValue = switchStringParts.get(1);
                    if (foundSwitch != null) {
                        inputValues.put(foundSwitch, switchValue);
                        logger.info("Parsing switch {} -> {}", (Object)switchName, (Object)switchValue);
                        continue;
                    }
                    unknownValues.put(switchName, switchValue);
                    logger.warn("Unknown switch {} -> {}", (Object)switchName, (Object)switchValue);
                    continue;
                }
                catch (Exception e) {
                    throw new CoreException("Problem parsing switch {}", currentSwitch, e);
                }
            }
            for (Switch switchObject : switches.values()) {
                if (inputValues.containsKey(switchObject)) continue;
                if (switchObject.getOptionality() == Optionality.REQUIRED) {
                    throw new CoreException("Missing Required Switch: {}", switchObject);
                }
                if (switchObject.getDefault() != null) {
                    inputValues.put(switchObject, switchObject.getDefaultResult());
                }
                logger.warn("Running without switch {}", (Object)switchObject);
            }
            this.command = new CommandMap();
            for (Switch switchObject : inputValues.keySet()) {
                this.command.put(switchObject.getName(), switchObject.get((String)inputValues.get(switchObject)));
            }
            this.lastRawCommand = inputValues;
            this.command.putAll(unknownValues);
        }
        return this.command;
    }

    public void run(String ... arguments) {
        try {
            System.exit(this.execute(arguments));
        }
        catch (Throwable throwable) {
            logger.error("Command execution failed.", throwable);
            System.exit(1);
        }
    }

    public void runWithoutQuitting(String ... arguments) {
        try {
            this.execute(arguments);
        }
        catch (Throwable throwable) {
            throw new CoreException("Command execution failed.", throwable);
        }
    }

    protected String commandSummary() {
        StringList list = new StringList();
        this.command.forEach((key, value) -> {
            StringBuilder builder = new StringBuilder();
            builder.append((String)key);
            builder.append(" -> ");
            builder.append(value);
            list.add(builder.toString());
        });
        return list.join("\n");
    }

    protected String lastRawCommand(Switch<?> sswitch) {
        return this.lastRawCommand.get(sswitch);
    }

    protected abstract int onRun(CommandMap var1);

    protected abstract SwitchList switches();

    private int execute(String[] arguments) {
        return this.onRun(this.getCommandMap(arguments));
    }

    public static class SwitchList
    extends ArrayList<Switch<?>> {
        private static final long serialVersionUID = 6310935016772212513L;

        public SwitchList with(Switch<?> ... switches) {
            Iterables.asList(switches).forEach((? super T aSwitch) -> this.add(aSwitch));
            return this;
        }
    }

    public static class Switch<T> {
        private final String name;
        private final String description;
        private final StringConverter<T> converter;
        private final Optionality optionality;
        private final String defaultResult;

        public Switch(String name, String description, StringConverter<T> converter) {
            this(name, description, converter, Optionality.OPTIONAL);
        }

        public Switch(String name, String description, StringConverter<T> converter, Optionality optionality) {
            this.name = name;
            this.description = description;
            this.converter = converter;
            this.optionality = optionality;
            this.defaultResult = null;
        }

        public Switch(String name, String description, StringConverter<T> converter, Optionality optionality, String defaultResult) {
            this.name = name;
            this.description = description;
            this.converter = converter;
            this.optionality = optionality;
            this.defaultResult = defaultResult;
        }

        public boolean equals(Object other) {
            if (other instanceof Switch) {
                Switch that = (Switch)other;
                return this.getName().equals(that.getName()) && this.getDescription().equals(that.getDescription());
            }
            return false;
        }

        public T get(String value) {
            if (value == null) {
                return null;
            }
            return (T)this.converter.convert(value);
        }

        public T getDefault() {
            return this.get(this.defaultResult);
        }

        public String getDescription() {
            Object defaultDescription = "";
            if (this.defaultResult != null) {
                defaultDescription = " Default is: " + this.defaultResult.toString();
            }
            return this.description + (String)defaultDescription;
        }

        public String getName() {
            return this.name;
        }

        public Optionality getOptionality() {
            return this.optionality;
        }

        public int hashCode() {
            return this.name.hashCode() + this.description.hashCode() + this.converter.hashCode();
        }

        public String toString() {
            return "[Switch: name = " + this.getName() + ", description = " + this.getDescription() + "]";
        }

        protected String getDefaultResult() {
            return this.defaultResult;
        }

        protected boolean hasDefaultResult() {
            return this.defaultResult != null;
        }
    }

    public static enum Optionality {
        REQUIRED,
        OPTIONAL;

    }

    public static class Flag
    extends Switch<Boolean> {
        public Flag(String name, String description) {
            super(name, description, value -> Boolean.valueOf(value), Optionality.OPTIONAL, Boolean.FALSE.toString());
        }

        public Flag(String name, String description, Optionality optionality) {
            super(name, description, value -> Boolean.valueOf(value), optionality, Boolean.FALSE.toString());
        }

        public Flag(String name, String description, Optionality optionality, String defaultValue) {
            super(name, description, value -> Boolean.valueOf(value), optionality, defaultValue);
        }
    }
}

